<?php
/**
 * Localized data
 *
 * @copyright Copyright (C) 2010-2024 Combodo SAS
 * @license    https://opensource.org/licenses/AGPL-3.0
 * 
 */
/**
 * @author Lukáš Dvořák <lukas.dvorak@itopportal.cz>
 * @author Daniel Rokos <daniel.rokos@itopportal.cz>
 *
 */
Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Core:DeletedObjectLabel' => '%1s (odstraněn)',
	'Core:DeletedObjectTip' => 'Objekt byl odstraněn %1$s (%2$s)',
	'Core:UnknownObjectLabel' => 'Objekt nenalezen (třída: %1$s, id: %2$d)',
	'Core:UnknownObjectTip' => 'Objekt nemohl být nalezen. Je možné, že byl odstraněn před nějakou dobou a protokol byl mezitím vyčištěn.',
	'Core:UniquenessDefaultError' => 'Uniqueness rule \'%1$s\' in error~~',
	'Core:CheckConsistencyError' => 'Nedodržena pravidla konzistence: %1$s',
	'Core:CheckValueError' => 'Neočekávaná hodnota atributu \'%1$s\' (%2$s) : %3$s',
	'Core:AttributeLinkedSet' => 'Pole objektů',
	'Core:AttributeLinkedSet+' => 'Jakékoli objekty stejné třídy, nebo podtřídy',
	'Core:AttributeLinkedSetDuplicatesFound' => 'Duplicita \'%1$s\' pole : %2$s',
	'Core:AttributeDashboard' => 'Nástěnka',
	'Core:AttributeDashboard+' => '',
	'Core:AttributePhoneNumber' => 'Telefonní číslo',
	'Core:AttributePhoneNumber+' => '',
	'Core:AttributeObsolescenceDate' => 'Datum zastarání',
	'Core:AttributeObsolescenceDate+' => '',
	'Core:AttributeTagSet' => 'Seznam tagů',
	'Core:AttributeTagSet+' => '',
	'Core:AttributeSet:placeholder' => 'Kliknutím přidej',
	'Core:Placeholder:CannotBeResolved' => '(%1$s : cannot be resolved)~~',
	'Core:AttributeClassAttCodeSet:ItemLabel:AttributeFromClass' => '%1$s (%2$s)',
	'Core:AttributeClassAttCodeSet:ItemLabel:AttributeFromOneChildClass' => '%1$s (%2$s z %3$s)',
	'Core:AttributeClassAttCodeSet:ItemLabel:AttributeFromSeveralChildClasses' => '%1$s (%2$s ze zděděné třídy)',
	'Core:AttributeCaseLog' => 'Log',
	'Core:AttributeCaseLog+' => '',
	'Core:AttributeMetaEnum' => 'Vypočítaný výčet',
	'Core:AttributeMetaEnum+' => '',
	'Core:AttributeLinkedSetIndirect' => 'Pole objektů (N-N)',
	'Core:AttributeLinkedSetIndirect+' => 'Jakékoli objekty stejné třídy, nebo podtřídy',
	'Core:AttributeInteger' => 'Celé číslo (integer)',
	'Core:AttributeInteger+' => 'Celé číslo (může být záporné)',
	'Core:AttributeDecimal' => 'Desetinné číslo (decimal)',
	'Core:AttributeDecimal+' => 'Desetinné číslo (může být záporné)',
	'Core:AttributeBoolean' => 'Boolean',
	'Core:AttributeBoolean+' => '',
	'Core:AttributeBoolean/Value:null' => '',
	'Core:AttributeBoolean/Value:yes' => 'Ano',
	'Core:AttributeBoolean/Value:no' => 'Ne',
	'Core:AttributeArchiveFlag' => 'Příznak archivovaného',
	'Core:AttributeArchiveFlag/Value:yes' => 'Ano',
	'Core:AttributeArchiveFlag/Value:yes+' => 'Tento objekt je možné vidět pouze v režimu archivu',
	'Core:AttributeArchiveFlag/Value:no' => 'Ne',
	'Core:AttributeArchiveFlag/Label' => 'Archivován',
	'Core:AttributeArchiveFlag/Label+' => '',
	'Core:AttributeArchiveDate/Label' => 'Datum archivace',
	'Core:AttributeArchiveDate/Label+' => '',
	'Core:AttributeObsolescenceFlag' => 'Příznak zastaralého',
	'Core:AttributeObsolescenceFlag/Value:yes' => 'Ano',
	'Core:AttributeObsolescenceFlag/Value:yes+' => 'Tento objekt je vyřazen z dopadových analýz a skryt pro vyhledávání',
	'Core:AttributeObsolescenceFlag/Value:no' => 'Ne',
	'Core:AttributeObsolescenceFlag/Label' => 'Zastaralý',
	'Core:AttributeObsolescenceFlag/Label+' => 'Vypočteno na základě ostatních atributů',
	'Core:AttributeObsolescenceDate/Label' => 'Datum zastarání',
	'Core:AttributeObsolescenceDate/Label+' => 'Přibližné datum, ke kterému byl objekt považován za zastaralý',
	'Core:AttributeString' => 'Řetězec (string)',
	'Core:AttributeString+' => 'Alfanumerický řetězec',
	'Core:AttributeClass' => 'Třída (class)',
	'Core:AttributeClass+' => '',
	'Core:AttributeApplicationLanguage' => 'Jazyk',
	'Core:AttributeApplicationLanguage+' => 'Jazyk a země (CS CZ)',
	'Core:AttributeFinalClass' => 'Třída (auto)',
	'Core:AttributeFinalClass+' => 'Skutečná třída objektu (automaticky vytvořeno jádrem)',
	'Core:AttributePassword' => 'Heslo',
	'Core:AttributePassword+' => 'Heslo k externímu zařízení',
	'Core:AttributeEncryptedString' => 'Šifrovaný řetězec',
	'Core:AttributeEncryptedString+' => 'Řetězec šifrovaný lokálním klíčem',
	'Core:AttributeEncryptUnknownLibrary' => 'Zadaná šifrovací knihovna (%1$s) není známa',
	'Core:AttributeEncryptFailedToDecrypt' => '** chyba dešifrování **',
	'Core:AttributeText' => 'Text',
	'Core:AttributeText+' => 'Víceřádkový řetězec znaků',
	'Core:AttributeHTML' => 'HTML',
	'Core:AttributeHTML+' => 'HTML řetězec',
	'Core:AttributeEmailAddress' => 'Emailová addresa',
	'Core:AttributeEmailAddress+' => 'Emailová addresa',
	'Core:AttributeIPAddress' => 'IP adresa',
	'Core:AttributeIPAddress+' => '',
	'Core:AttributeOQL' => 'OQL',
	'Core:AttributeOQL+' => 'Výraz v jazyce OQL',
	'Core:AttributeEnum' => 'Enum',
	'Core:AttributeEnum+' => 'Seznam předdefinovaných alfanumerických řetězců',
	'Core:AttributeTemplateString' => 'Šablona - řetězec',
	'Core:AttributeTemplateString+' => 'Řetězec obsahující zástupné symboly',
	'Core:AttributeTemplateText' => 'Šablona - text',
	'Core:AttributeTemplateText+' => 'Text obsahující zástupné symboly',
	'Core:AttributeTemplateHTML' => 'Šablona - HTML',
	'Core:AttributeTemplateHTML+' => 'HTML obsahující zástupné symboly',
	'Core:AttributeDateTime' => 'Datum a čas',
	'Core:AttributeDateTime+' => 'Datum a čas (rok-měsíc-den hh:mm:ss)',
	'Core:AttributeDateTime?SmartSearch' => '
<p>
    Formát data:<br/>
    <b>%1$s</b><br/>
    Například: %2$s
</p>
<p>
Operátory:<br/>
    <b>&gt;</b><em>datum</em><br/>
    <b>&lt;</b><em>datum</em><br/>
    <b>[</b><em>datum</em>,<em>datum</em><b>]</b>
</p>
<p>
Je-li čas vynechán, bude nastaveno 00:00:00
</p>',
	'Core:AttributeDate' => 'Datum',
	'Core:AttributeDate+' => 'Datum (rok-měsíc-den)',
	'Core:AttributeDate?SmartSearch' => '
<p>
    Formát data:<br/>
    <b>%1$s</b><br/>
    Například: %2$s
</p>
<p>
Operátory:<br/>
    <b>&gt;</b><em>datum</em><br/>
    <b>&lt;</b><em>datum</em><br/>
    <b>[</b><em>datum</em>,<em>datum</em><b>]</b>
</p>',
	'Core:AttributeDeadline' => 'Uzávěrka',
	'Core:AttributeDeadline+' => 'Datum, zobrazeno relativně k aktuálnímu času',
	'Core:AttributeExternalKey' => 'Externí klíč',
	'Core:AttributeExternalKey+' => 'Externí (cizí) klíč',
	'Core:AttributeHierarchicalKey' => 'Hierarchický klíč',
	'Core:AttributeHierarchicalKey+' => 'Externí (cizí) klíč nadřízené položky',
	'Core:AttributeExternalField' => 'Externí pole',
	'Core:AttributeExternalField+' => 'Pole mapované na externí klíč',
	'Core:AttributeURL' => 'URL',
	'Core:AttributeURL+' => 'Absolutní nebo relativní URL jako textový řetězec',
	'Core:AttributeBlob' => 'Blob',
	'Core:AttributeBlob+' => 'Jakýkoli binární obsah (dokument)',
	'Core:AttributeOneWayPassword' => 'Jednosměrně šifrované heslo',
	'Core:AttributeOneWayPassword+' => '',
	'Core:AttributeTable' => 'Tabulka',
	'Core:AttributeTable+' => 'Dvourozměrné indexované pole',
	'Core:AttributePropertySet' => 'Vlastnosti',
	'Core:AttributePropertySet+' => 'Seznam vlastností bez typu (název a hodnota)',
	'Core:AttributeFriendlyName' => 'Popisný název',
	'Core:AttributeFriendlyName+' => 'Atribut vyplněný automaticky; popisný název je složen z několika dalších atributů',
	'Core:FriendlyName-Label' => 'Popisný název',
	'Core:FriendlyName-Description' => 'Popisný název',
	'Core:AttributeTag' => 'Tagy',
	'Core:AttributeTag+' => '',
	'Core:Context=REST/JSON' => 'REST~~',
	'Core:Context=Synchro' => 'Synchro',
	'Core:Context=Setup' => 'Nastavení',
	'Core:Context=GUI:Console' => 'Konzole',
	'Core:Context=CRON' => 'cron',
	'Core:Context=GUI:Portal' => 'Portal',
));


//////////////////////////////////////////////////////////////////////
// Classes in 'core/cmdb'
//////////////////////////////////////////////////////////////////////
//

//
// Class: CMDBChange
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:CMDBChange' => 'Změna',
	'Class:CMDBChange+' => 'Trasování změn',
	'Class:CMDBChange/Attribute:date' => 'datum',
	'Class:CMDBChange/Attribute:date+' => 'datum a čas při kterém byly změny zaznamenány',
	'Class:CMDBChange/Attribute:userinfo' => 'informace',
	'Class:CMDBChange/Attribute:userinfo+' => 'informace definované zadavatelem',
	'Class:CMDBChange/Attribute:origin/Value:interactive' => 'Uživatelská interakce v GUI',
	'Class:CMDBChange/Attribute:origin/Value:csv-import.php' => 'CSV import script',
	'Class:CMDBChange/Attribute:origin/Value:csv-interactive' => 'CSV import prostřednictvím GUI',
	'Class:CMDBChange/Attribute:origin/Value:email-processing' => 'Zpracování emailu',
	'Class:CMDBChange/Attribute:origin/Value:synchro-data-source' => 'Zdroje dat pro synchronizaci',
	'Class:CMDBChange/Attribute:origin/Value:webservice-rest' => 'Webové služby REST/JSON',
	'Class:CMDBChange/Attribute:origin/Value:webservice-soap' => 'Wbové služby SOAP',
	'Class:CMDBChange/Attribute:origin/Value:custom-extension' => 'Rozšíření',
));

//
// Class: CMDBChangeOp
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:CMDBChangeOp' => 'Změna operace',
	'Class:CMDBChangeOp+' => 'Tracking provozu změn',
	'Class:CMDBChangeOp/Attribute:change' => 'změna',
	'Class:CMDBChangeOp/Attribute:change+' => '',
	'Class:CMDBChangeOp/Attribute:date' => 'datum',
	'Class:CMDBChangeOp/Attribute:date+' => 'datum a čas změny',
	'Class:CMDBChangeOp/Attribute:userinfo' => 'uživatel',
	'Class:CMDBChangeOp/Attribute:userinfo+' => 'kdo provedl tuto změnu',
	'Class:CMDBChangeOp/Attribute:objclass' => 'třída objektů',
	'Class:CMDBChangeOp/Attribute:objclass+' => 'třída objektů',
	'Class:CMDBChangeOp/Attribute:objkey' => 'ID objektu',
	'Class:CMDBChangeOp/Attribute:objkey+' => '',
	'Class:CMDBChangeOp/Attribute:finalclass' => 'typ',
	'Class:CMDBChangeOp/Attribute:finalclass+' => '',
));

//
// Class: CMDBChangeOpCreate
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:CMDBChangeOpCreate' => 'vytvoření objektu',
	'Class:CMDBChangeOpCreate+' => 'Tracking vytvoření objektu',
));

//
// Class: CMDBChangeOpDelete
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:CMDBChangeOpDelete' => 'odstranění objektu',
	'Class:CMDBChangeOpDelete+' => 'Tracking odstranění objektu',
));

//
// Class: CMDBChangeOpSetAttribute
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:CMDBChangeOpSetAttribute' => 'změna objektu',
	'Class:CMDBChangeOpSetAttribute+' => 'Tracking úprav objektu',
	'Class:CMDBChangeOpSetAttribute/Attribute:attcode' => 'Atribut',
	'Class:CMDBChangeOpSetAttribute/Attribute:attcode+' => 'kód upravené vlastnosti',
));

//
// Class: CMDBChangeOpSetAttributeScalar
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:CMDBChangeOpSetAttributeScalar' => 'změna vlastnosti objektu',
	'Class:CMDBChangeOpSetAttributeScalar+' => 'Záznam změny objektu',
	'Class:CMDBChangeOpSetAttributeScalar/Attribute:oldvalue' => 'Předchozí hodnota',
	'Class:CMDBChangeOpSetAttributeScalar/Attribute:oldvalue+' => '',
	'Class:CMDBChangeOpSetAttributeScalar/Attribute:newvalue' => 'Nová hodnota',
	'Class:CMDBChangeOpSetAttributeScalar/Attribute:newvalue+' => '',
));
// Used by CMDBChangeOp... & derived classes
Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Change:ObjectCreated' => 'Objekt vytvořen',
	'Change:ObjectDeleted' => 'Objekt odstraněn',
	'Change:ObjectModified' => 'Objekt upraven',
	'Change:TwoAttributesChanged' => 'Upraven %1$s a %2$s',
	'Change:ThreeAttributesChanged' => 'Upraven %1$s, %2$s a 1 další',
	'Change:FourOrMoreAttributesChanged' => 'Upraveno %1$s, %2$s a %3$s další',
	'Change:AttName_SetTo_NewValue_PreviousValue_OldValue' => 'Atribut %1$s nastaven na hodnotu %2$s (předchozí hodnota: %3$s)',
	'Change:AttName_SetTo' => 'Atribut %1$s nastaven na hodnotu %2$s',
	'Change:Text_AppendedTo_AttName' => '%1$s připojen k %2$s',
	'Change:AttName_Changed_PreviousValue_OldValue' => '%1$s upraven, předchozí hodnota: %2$s',
	'Change:AttName_Changed' => '%1$s upraven',
	'Change:AttName_EntryAdded' => '%1$s upraven, přidána nová položka.',
	'Change:State_Changed_NewValue_OldValue' => 'Změněn z %2$s na %1$s',
	'Change:LinkSet:Added' => 'přidán %1$s',
	'Change:LinkSet:Removed' => 'odstraněn %1$s',
	'Change:LinkSet:Modified' => 'upraven %1$s',
));

//
// Class: CMDBChangeOpSetAttributeBlob
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:CMDBChangeOpSetAttributeBlob' => 'změna dat',
	'Class:CMDBChangeOpSetAttributeBlob+' => 'Tracking změny dat',
	'Class:CMDBChangeOpSetAttributeBlob/Attribute:prevdata' => 'Předchozí data',
	'Class:CMDBChangeOpSetAttributeBlob/Attribute:prevdata+' => '',
));

//
// Class: CMDBChangeOpSetAttributeText
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:CMDBChangeOpSetAttributeText' => 'změna textu',
	'Class:CMDBChangeOpSetAttributeText+' => 'Tracking změny textu',
	'Class:CMDBChangeOpSetAttributeText/Attribute:prevdata' => 'Předchozí data',
	'Class:CMDBChangeOpSetAttributeText/Attribute:prevdata+' => '',
));

//
// Class: Event
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:Event' => 'Událost',
	'Class:Event+' => '',
	'Class:Event/Attribute:message' => 'Zpráva',
	'Class:Event/Attribute:message+' => 'krátký popis události',
	'Class:Event/Attribute:date' => 'Datum',
	'Class:Event/Attribute:date+' => 'datum a čas při kterém byla událost zaznamenána',
	'Class:Event/Attribute:userinfo' => 'Informace o uživateli',
	'Class:Event/Attribute:userinfo+' => 'identifikace uživatele, který spustil tuto událost',
	'Class:Event/Attribute:finalclass' => 'Typ',
	'Class:Event/Attribute:finalclass+' => '',
));

//
// Class: EventNotification
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:EventNotification' => 'Upozornění',
	'Class:EventNotification+' => '',
	'Class:EventNotification/Attribute:trigger_id' => 'Triger',
	'Class:EventNotification/Attribute:trigger_id+' => '',
	'Class:EventNotification/Attribute:action_id' => 'Akce',
	'Class:EventNotification/Attribute:action_id+' => '',
	'Class:EventNotification/Attribute:object_id' => 'Objekt',
	'Class:EventNotification/Attribute:object_id+' => '',
));

//
// Class: EventNotificationEmail
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:EventNotificationEmail' => 'Odeslání emailu',
	'Class:EventNotificationEmail+' => '',
	'Class:EventNotificationEmail/Attribute:to' => 'Pro',
	'Class:EventNotificationEmail/Attribute:to+' => '',
	'Class:EventNotificationEmail/Attribute:cc' => 'Kopie',
	'Class:EventNotificationEmail/Attribute:cc+' => '',
	'Class:EventNotificationEmail/Attribute:bcc' => 'Skrytá kopie',
	'Class:EventNotificationEmail/Attribute:bcc+' => '',
	'Class:EventNotificationEmail/Attribute:from' => 'Odesílatel',
	'Class:EventNotificationEmail/Attribute:from+' => '',
	'Class:EventNotificationEmail/Attribute:subject' => 'Předmět',
	'Class:EventNotificationEmail/Attribute:subject+' => '',
	'Class:EventNotificationEmail/Attribute:body' => 'Tělo',
	'Class:EventNotificationEmail/Attribute:body+' => '',
	'Class:EventNotificationEmail/Attribute:attachments' => 'Přílohy',
	'Class:EventNotificationEmail/Attribute:attachments+' => '',
));

//
// Class: EventIssue
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:EventIssue' => 'Chyba',
	'Class:EventIssue+' => '',
	'Class:EventIssue/Attribute:issue' => 'Chyba',
	'Class:EventIssue/Attribute:issue+' => '',
	'Class:EventIssue/Attribute:impact' => 'Dopad',
	'Class:EventIssue/Attribute:impact+' => '',
	'Class:EventIssue/Attribute:page' => 'Stránka',
	'Class:EventIssue/Attribute:page+' => '',
	'Class:EventIssue/Attribute:arguments_post' => 'POST argumenty',
	'Class:EventIssue/Attribute:arguments_post+' => '',
	'Class:EventIssue/Attribute:arguments_get' => 'GET argumenty',
	'Class:EventIssue/Attribute:arguments_get+' => '',
	'Class:EventIssue/Attribute:callstack' => 'Zásobník volání',
	'Class:EventIssue/Attribute:callstack+' => '',
	'Class:EventIssue/Attribute:data' => 'Data',
	'Class:EventIssue/Attribute:data+' => '',
));

//
// Class: EventWebService
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:EventWebService' => 'Volání webové služby',
	'Class:EventWebService+' => '',
	'Class:EventWebService/Attribute:verb' => 'Název operace',
	'Class:EventWebService/Attribute:verb+' => '',
	'Class:EventWebService/Attribute:result' => 'Výsledek',
	'Class:EventWebService/Attribute:result+' => '',
	'Class:EventWebService/Attribute:log_info' => 'Informace',
	'Class:EventWebService/Attribute:log_info+' => '',
	'Class:EventWebService/Attribute:log_warning' => 'Varování',
	'Class:EventWebService/Attribute:log_warning+' => '',
	'Class:EventWebService/Attribute:log_error' => 'Chyby',
	'Class:EventWebService/Attribute:log_error+' => '',
	'Class:EventWebService/Attribute:data' => 'Data',
	'Class:EventWebService/Attribute:data+' => '',
));

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:EventRestService' => 'Volání REST/JSON',
	'Class:EventRestService+' => 'Stopa REST/JSON volání',
	'Class:EventRestService/Attribute:operation' => 'Operace',
	'Class:EventRestService/Attribute:operation+' => 'Argument \'operation\'',
	'Class:EventRestService/Attribute:version' => 'Verze',
	'Class:EventRestService/Attribute:version+' => 'Argument \'version\'',
	'Class:EventRestService/Attribute:json_input' => 'Vstup (data)',
	'Class:EventRestService/Attribute:json_input+' => 'Argument \'json_data\'',
	'Class:EventRestService/Attribute:code' => 'Kód',
	'Class:EventRestService/Attribute:code+' => 'Výsledný kód',
	'Class:EventRestService/Attribute:json_output' => 'Odpověď',
	'Class:EventRestService/Attribute:json_output+' => 'HTTP response (json)',
	'Class:EventRestService/Attribute:provider' => 'Poskytovatel',
	'Class:EventRestService/Attribute:provider+' => 'Třída PHP implementující očekávanou operaci',
));

//
// Class: EventLoginUsage
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:EventLoginUsage' => 'Použití aplikace',
	'Class:EventLoginUsage+' => '',
	'Class:EventLoginUsage/Attribute:user_id' => 'Login',
	'Class:EventLoginUsage/Attribute:user_id+' => 'Uživatelské jméno',
	'Class:EventLoginUsage/Attribute:contact_name' => 'Kontakt',
	'Class:EventLoginUsage/Attribute:contact_name+' => 'Kontaktní informace uživatele',
	'Class:EventLoginUsage/Attribute:contact_email' => 'Emailová adresa uživatele',
	'Class:EventLoginUsage/Attribute:contact_email+' => '',
));

//
// Class: EventNotificationNewsroom
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:EventNotificationNewsroom' => 'Zaslané novinky',
	'Class:EventNotificationNewsroom+' => '~~',
	'Class:EventNotificationNewsroom/Attribute:title' => 'Titulek',
	'Class:EventNotificationNewsroom/Attribute:title+' => '~~',
	'Class:EventNotificationNewsroom/Attribute:icon' => 'Ikona',
	'Class:EventNotificationNewsroom/Attribute:icon+' => '~~',
	'Class:EventNotificationNewsroom/Attribute:priority' => 'Priorita',
	'Class:EventNotificationNewsroom/Attribute:priority+' => '~~',
	'Class:EventNotificationNewsroom/Attribute:priority/Value:1' => 'Kritická',
	'Class:EventNotificationNewsroom/Attribute:priority/Value:1+' => 'Kritická',
	'Class:EventNotificationNewsroom/Attribute:priority/Value:2' => 'Urgentní',
	'Class:EventNotificationNewsroom/Attribute:priority/Value:2+' => 'Urgentní',
	'Class:EventNotificationNewsroom/Attribute:priority/Value:3' => 'Důležitá',
	'Class:EventNotificationNewsroom/Attribute:priority/Value:3+' => 'Důležitá',
	'Class:EventNotificationNewsroom/Attribute:priority/Value:4' => 'Standardní',
	'Class:EventNotificationNewsroom/Attribute:priority/Value:4+' => 'Standardní',
	'Class:EventNotificationNewsroom/Attribute:url' => 'URL',
	'Class:EventNotificationNewsroom/Attribute:url+' => '~~',
	'Class:EventNotificationNewsroom/Attribute:read' => 'Číst',
	'Class:EventNotificationNewsroom/Attribute:read+' => '~~',
	'Class:EventNotificationNewsroom/Attribute:read/Value:no' => 'Ne',
	'Class:EventNotificationNewsroom/Attribute:read/Value:no+' => 'Ne',
	'Class:EventNotificationNewsroom/Attribute:read/Value:yes' => 'Ano',
	'Class:EventNotificationNewsroom/Attribute:read/Value:yes+' => 'Ano',
	'Class:EventNotificationNewsroom/Attribute:read_date' => 'Datum přečtení',
	'Class:EventNotificationNewsroom/Attribute:read_date+' => '~~',
	'Class:EventNotificationNewsroom/Attribute:contact_id' => 'Kontakt',
	'Class:EventNotificationNewsroom/Attribute:contact_id+' => '~~',
));

//
// Class: Action
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:Action' => 'Vlastní akce',
	'Class:Action+' => '',
	'Class:Action/ComplementaryName' => '%1$s: %2$s',
	'Class:Action/Attribute:name' => 'Název',
	'Class:Action/Attribute:name+' => '',
	'Class:Action/Attribute:description' => 'Popis',
	'Class:Action/Attribute:description+' => '',
	'Class:Action/Attribute:status' => 'Stav',
	'Class:Action/Attribute:status+' => '',
	'Class:Action/Attribute:status/Value:test' => 'Testování',
	'Class:Action/Attribute:status/Value:test+' => '',
	'Class:Action/Attribute:status/Value:enabled' => 'V produkci',
	'Class:Action/Attribute:status/Value:enabled+' => '',
	'Class:Action/Attribute:status/Value:disabled' => 'Neaktivní',
	'Class:Action/Attribute:status/Value:disabled+' => '',
	'Class:Action/Attribute:trigger_list' => 'Související trigery',
	'Class:Action/Attribute:trigger_list+' => 'Trigery spojené s touto akcí',
	'Class:Action/Attribute:asynchronous' => 'Asynchronnní',
	'Class:Action/Attribute:asynchronous+' => 'Zda se má akce provádět na pozadí, nebo ne.',
	'Class:Action/Attribute:asynchronous/Value:use_global_setting' => 'Použít globální nastavení',
	'Class:Action/Attribute:asynchronous/Value:yes' => 'Ano',
	'Class:Action/Attribute:asynchronous/Value:no' => 'Ne',
	'Class:Action/Attribute:finalclass' => 'Typ',
	'Class:Action/Attribute:finalclass+' => '',
	'Action:WarningNoTriggerLinked' => 'Varování, s akcí není spojen žádný triger. Akce nebude aktivní, dokud nebude mít alespoň jeden triger',
	'Action:last_executions_tab' => 'Poslední provedení',
	'Action:last_executions_tab_panel_title' => 'Provedení této akce (%1$s)',
	'Action:last_executions_tab_limit_days' => 'posledních %1$s dní',
	'Action:last_executions_tab_limit_none' => 'bez omezení',
));

//
// Class: ActionNotification
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:ActionNotification' => 'Upozornění',
	'Class:ActionNotification+' => 'Upozornění (abstraktní)',
	'Class:ActionNotification/Attribute:language' => 'Language~~',
	'Class:ActionNotification/Attribute:language+' => '~~',
));

//
// Class: ActionEmail
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:ActionEmail' => 'Emailové upozornění',
	'Class:ActionEmail+' => '',
	'Class:ActionEmail/Attribute:status+' => 'Tento stav určuje, kdo bude upozorněn: 
- Testování: pouze adresát pro test, 
- V produkci: všichni (komu, kopie, skrytá kopie) 
- Neaktivní: nikdo',
	'Class:ActionEmail/Attribute:status/Value:test+' => 'Upozornění je odesláno pouze adresátovi pro test',
	'Class:ActionEmail/Attribute:status/Value:enabled+' => 'Všem adresátům (komu, kopie, skrytá kopie) je emailové upozornění odesláno',
	'Class:ActionEmail/Attribute:status/Value:disabled+' => 'Emailové upozornění nebude odesláno',
	'Class:ActionEmail/Attribute:test_recipient' => 'Adresát pro test',
	'Class:ActionEmail/Attribute:test_recipient+' => 'Cílová adresa pro případ, kdy je stav nastaven na "Testování"',
	'Class:ActionEmail/Attribute:from' => 'Odesílatel',
	'Class:ActionEmail/Attribute:from+' => '',
	'Class:ActionEmail/Attribute:from_label' => 'Od (označení)',
	'Class:ActionEmail/Attribute:from_label+' => 'Statické označení nebo zástupný znak jako $this->agent_id->friendlyname$',
	'Class:ActionEmail/Attribute:reply_to' => 'Odpověď na',
	'Class:ActionEmail/Attribute:reply_to+' => '',
	'Class:ActionEmail/Attribute:reply_to_label' => 'Odpověď na (označení)',
	'Class:ActionEmail/Attribute:reply_to_label+' => 'Statické označení nebo zástupný znak jako $this->team_id->friendlyname$.
If omitted the From (label) is used.',
	'Class:ActionEmail/Attribute:to' => 'To',
	'Class:ActionEmail/Attribute:to+' => 'Adresát',
	'Class:ActionEmail/Attribute:cc' => 'Kopie',
	'Class:ActionEmail/Attribute:cc+' => 'Kopie',
	'Class:ActionEmail/Attribute:bcc' => 'Skrytá kopie',
	'Class:ActionEmail/Attribute:bcc+' => 'Skrytá kopie',
	'Class:ActionEmail/Attribute:subject' => 'Předmět',
	'Class:ActionEmail/Attribute:subject+' => '',
	'Class:ActionEmail/Attribute:body' => 'Tělo',
	'Class:ActionEmail/Attribute:body+' => 'Obsah zprávy',
	'Class:ActionEmail/Attribute:importance' => 'Důležitost',
	'Class:ActionEmail/Attribute:importance+' => 'Příznak důležitosti',
	'Class:ActionEmail/Attribute:importance/Value:low' => 'nízká',
	'Class:ActionEmail/Attribute:importance/Value:low+' => '',
	'Class:ActionEmail/Attribute:importance/Value:normal' => 'normalní',
	'Class:ActionEmail/Attribute:importance/Value:normal+' => '',
	'Class:ActionEmail/Attribute:importance/Value:high' => 'vysoká',
	'Class:ActionEmail/Attribute:importance/Value:high+' => '',
	'Class:ActionEmail/Attribute:language' => 'Jazyk',
	'Class:ActionEmail/Attribute:language+' => 'Jazyk použitý pro zástupné znaky ($xxx$) uvnitř zprávy (stav, důležitost, priorita atd.)',
	'Class:ActionEmail/Attribute:html_template' => 'HTML šablona',
	'Class:ActionEmail/Attribute:html_template+' => 'Volitelná HTML šablona obsahující níže uvedený atribut \'Body\', užitečná pro rozvržení emailu (v šabloně obsah atributu \'Body\' nahradí zástupný znak $content$)',
	'Class:ActionEmail/Attribute:ignore_notify' => 'Ignorovat Upozornění',
	'Class:ActionEmail/Attribute:ignore_notify+' => 'Pokud je nastaveno \'Ano\', příznak \'Upozornění\' u kontaktu nemá žádný vliv.',
	'Class:ActionEmail/Attribute:ignore_notify/Value:no' => 'Ne',
	'Class:ActionEmail/Attribute:ignore_notify/Value:yes' => 'Ano',
	'ActionEmail:main' => 'Zpráva',
	'ActionEmail:trigger' => 'Spouštěče',
	'ActionEmail:recipients' => 'Kontakty',
	'ActionEmail:preview_tab' => 'Náhled',
	'ActionEmail:preview_tab+' => 'Náhled emailové šablony',
	'ActionEmail:preview_warning' => 'Finální podoba emailu může vypadat v emailovém klientu jinak, než tento aktuální náhled v prohlížeci',
	'ActionEmail:preview_more_info' => 'Další informace ohledně podpory CSS v emailových klientech, se dozvíte zde %1$s',
	'ActionEmail:content_placeholder_missing' => 'Odkaz "%1$s" nebyl v HMTL šabloně nalezen. Obsah pole "%2$s" nebude součástí generovaného emailu',
));


//
// Class: ActionNewsroom
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'ActionNewsroom:trigger' => 'Triger',
	'ActionNewsroom:content' => 'Zpráva',
	'ActionNewsroom:settings' => 'Nastavení',
	'Class:ActionNewsroom' => 'Notifikace v novinkách',
	'Class:ActionNewsroom+' => '~~',
	'Class:ActionNewsroom/Attribute:title' => 'Titulek',
	'Class:ActionNewsroom/Attribute:title+' => 'Titulek novinky. Může obsahovat zástupné znaky jako $this->attribute_code$',
	'Class:ActionNewsroom/Attribute:message' => 'Zpráva',
	'Class:ActionNewsroom/Attribute:message+' => 'Obsah novinek ve formátu Markdow, nikoli HTML. Může obsahovat zástupné znaky, jako např.:
- $this->attribute_code$ jakýkoli atribut objektu, který vyvolal upozornění,
- $this->attribute_external_key->attribute$ rekurzivní syntaxe pro libovolný vzdálený atribut,
- $current_contact->attribute$ atribut osoby, která upozornění spustila',
	'Class:ActionNewsroom/Attribute:icon' => 'Ikona',
	'Class:ActionNewsroom/Attribute:icon+' => 'Ikona, která se zobrazí vedle zpráv v novinkách.
- Pokud je vyplněna, použite se vlastní ikona
- V opačném případě, pokud má ikonu spouštěný objekt (např. obrázek objektu Osoba), použije se tato ikona
- V opačném případě, pokud má třída spouštěného objektu ikonu definovanou v datovém modelu, použije se tato ikona
- V opačném případě se použije kompaktní logo aplikace',
	'Class:ActionNewsroom/Attribute:priority' => 'Priorita',
	'Class:ActionNewsroom/Attribute:priority+' => '~~',
	'Class:ActionNewsroom/Attribute:priority/Value:1' => 'Kritická',
	'Class:ActionNewsroom/Attribute:priority/Value:1+' => 'Kritická',
	'Class:ActionNewsroom/Attribute:priority/Value:2' => 'Urgentní',
	'Class:ActionNewsroom/Attribute:priority/Value:2+' => 'Urgentní',
	'Class:ActionNewsroom/Attribute:priority/Value:3' => 'Důležitá',
	'Class:ActionNewsroom/Attribute:priority/Value:3+' => 'Důležitá',
	'Class:ActionNewsroom/Attribute:priority/Value:4' => 'Standardní',
	'Class:ActionNewsroom/Attribute:priority/Value:4+' => 'Standardní',
	'Class:ActionNewsroom/Attribute:test_recipient_id' => 'Adresát pro test',
	'Class:ActionNewsroom/Attribute:test_recipient_id+' => 'Osoba použitá místo příjemce při testování upozornění',
	'Class:ActionNewsroom/Attribute:recipients' => 'Příjemci',
	'Class:ActionNewsroom/Attribute:recipients+' => 'Dotaz OQL vracející objekty Kontaktu',
	'Class:ActionNewsroom/Attribute:url' => 'URL',
	'Class:ActionNewsroom/Attribute:url+' => 'Pokud je URL prázdná, bude odkazovat na objekt, který upozornění spustil. Můžete však zadat vlastní URL adresu.',
));

//
// Class: Trigger
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:Trigger' => 'Triger',
	'Class:Trigger+' => '',
	'Class:Trigger/ComplementaryName' => '%1$s, %2$s~~',
	'Class:Trigger/Attribute:description' => 'Popis',
	'Class:Trigger/Attribute:description+' => 'Krátký popis',
	'Class:Trigger/Attribute:action_list' => 'Spouštěné akce',
	'Class:Trigger/Attribute:action_list+' => 'Akce prováděné, když je aktivován triger',
	'Class:Trigger/Attribute:finalclass' => 'Typ',
	'Class:Trigger/Attribute:finalclass+' => '',
	'Class:Trigger/Attribute:context' => 'Kontext',
	'Class:Trigger/Attribute:context+' => 'Kontext pro spuštění trigeru',
	'Class:Trigger/Attribute:complement' => 'Doplňující informace',
	'Class:Trigger/Attribute:complement+' => 'Další informace poskytnuté tímto trigerem v angličtině',
	'Class:Trigger/Attribute:subscription_policy' => 'Pravidla odběru',
	'Class:Trigger/Attribute:subscription_policy+' => 'Umožňuje uživatelům odhlásit se z odběru trigeru',
	'Class:Trigger/Attribute:subscription_policy/Value:allow_no_channel' => 'Povolit úplné odhlášení odběru',
	'Class:Trigger/Attribute:subscription_policy/Value:force_at_least_one_channel' => 'Vynucení alespoň jednoho kanálu (Novinka nebo Email)',
	'Class:Trigger/Attribute:subscription_policy/Value:force_all_channels' => 'Zakázat odmítnutí odběru',
));

//
// Class: TriggerOnObject
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:TriggerOnObject' => 'Triger \'závislý na třídě objektů\'',
	'Class:TriggerOnObject+' => '',
	'Class:TriggerOnObject/Attribute:target_class' => 'Cílová třída',
	'Class:TriggerOnObject/Attribute:target_class+' => '',
	'Class:TriggerOnObject/Attribute:filter' => 'Filtr',
	'Class:TriggerOnObject/Attribute:filter+' => 'Omezit seznam objektů (cílové třídy), které aktivují triger',
	'TriggerOnObject:WrongFilterQuery' => 'Špatný filtrační dotaz: %1$s',
	'TriggerOnObject:WrongFilterClass' => 'Filtrační dotaz musí vrátit objekty třídy "%1$s"',
));

//
// Class: TriggerOnPortalUpdate
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:TriggerOnPortalUpdate' => 'Triger \'aktualizace přes portál\'',
	'Class:TriggerOnPortalUpdate+' => 'Triger při aktualizaci koncovým uživatelem přes portál',
));

//
// Class: TriggerOnStateChange
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:TriggerOnStateChange' => 'Triger \'změna stavu\'',
	'Class:TriggerOnStateChange+' => '',
	'Class:TriggerOnStateChange/Attribute:state' => 'Stav',
	'Class:TriggerOnStateChange/Attribute:state+' => '',
));

//
// Class: TriggerOnStateEnter
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:TriggerOnStateEnter' => 'Triger \'změna stavu na\'',
	'Class:TriggerOnStateEnter+' => '',
));

//
// Class: TriggerOnStateLeave
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:TriggerOnStateLeave' => 'Triger \'změna stavu z\'',
	'Class:TriggerOnStateLeave+' => '',
));

//
// Class: TriggerOnObjectCreate
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:TriggerOnObjectCreate' => 'Triger \'vytvoření objektu\'',
	'Class:TriggerOnObjectCreate+' => '',
));

//
// Class: TriggerOnObjectDelete
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:TriggerOnObjectDelete' => 'Triger \'smazání objektu\'',
	'Class:TriggerOnObjectDelete+' => 'Spustit při smazání objektu [podřízené třídy] dané třídy',
));

//
// Class: TriggerOnObjectUpdate
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:TriggerOnObjectUpdate' => 'Triger \'aktualizace objektu\'',
	'Class:TriggerOnObjectUpdate+' => 'Spustit při aktualizaci objektu [podřízené třídy] dané třídy',
	'Class:TriggerOnObjectUpdate/Attribute:target_attcodes' => 'Cílová pole',
	'Class:TriggerOnObjectUpdate/Attribute:target_attcodes+' => '',
));

//
// Class: TriggerOnObjectMention
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:TriggerOnObjectMention' => 'Triger (při zmíňce objektu)',
	'Class:TriggerOnObjectMention+' => 'Spustit při zmínce (@xxx) o objektu [podřízené třídy] dané třídy v logu atributu',
	'Class:TriggerOnObjectMention/Attribute:mentioned_filter' => 'Filtr zmínek',
	'Class:TriggerOnObjectMention/Attribute:mentioned_filter+' => 'Omezit seznam zmíněných objektů, které aktivují triger. Pokud je prázdný, aktivuje jej libovolný zmíněný objekt (libovolné třídy).',
));

//
// Class: TriggerOnAttributeBlobDownload
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:TriggerOnAttributeBlobDownload' => 'Triger (při stažení pole dokumentu objektu)',
	'Class:TriggerOnAttributeBlobDownload+' => 'Spustit při stažení pole dokumentu objektu [podřízené třídy] dané třídy',
	'Class:TriggerOnAttributeBlobDownload/Attribute:target_attcodes' => 'Cílová pole',
	'Class:TriggerOnAttributeBlobDownload/Attribute:target_attcodes+' => '',
));

//
// Class: TriggerOnThresholdReached
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:TriggerOnThresholdReached' => 'Triger \'prahová hodnota\'',
	'Class:TriggerOnThresholdReached+' => '',
	'Class:TriggerOnThresholdReached/Attribute:stop_watch_code' => 'Stopky',
	'Class:TriggerOnThresholdReached/Attribute:stop_watch_code+' => '',
	'Class:TriggerOnThresholdReached/Attribute:threshold_index' => 'Prahová hodnota',
	'Class:TriggerOnThresholdReached/Attribute:threshold_index+' => '',
));

//
// Class: lnkTriggerAction
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:lnkTriggerAction' => 'Spojení (Akce / Triger)',
	'Class:lnkTriggerAction+' => '',
	'Class:lnkTriggerAction/Attribute:action_id' => 'Akce',
	'Class:lnkTriggerAction/Attribute:action_id+' => '',
	'Class:lnkTriggerAction/Attribute:action_name' => 'Akce',
	'Class:lnkTriggerAction/Attribute:action_name+' => '',
	'Class:lnkTriggerAction/Attribute:trigger_id' => 'Triger',
	'Class:lnkTriggerAction/Attribute:trigger_id+' => '',
	'Class:lnkTriggerAction/Attribute:trigger_name' => 'Triger',
	'Class:lnkTriggerAction/Attribute:trigger_name+' => '',
	'Class:lnkTriggerAction/Attribute:order' => 'Pořadí',
	'Class:lnkTriggerAction/Attribute:order+' => 'Pořadí, v jakém jsou akce vykonány',
));

//
// Synchro Data Source
//
Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:SynchroDataSource' => 'Zdroje dat pro synchronizaci',
	'Class:SynchroDataSource/Attribute:name' => 'Název',
	'Class:SynchroDataSource/Attribute:name+' => '',
	'Class:SynchroDataSource/Attribute:description' => 'Popis',
	'Class:SynchroDataSource/Attribute:status' => 'Stav',
	'Class:SynchroDataSource/Attribute:scope_class' => 'Cílová třída',
	'Class:SynchroDataSource/Attribute:scope_class+' => 'Zdroj dat pro synchronizaci může naplnit pouze jednu třídu '.ITOP_APPLICATION_SHORT.'',
	'Class:SynchroDataSource/Attribute:user_id' => 'Uživatel',
	'Class:SynchroDataSource/Attribute:notify_contact_id' => 'Kontakt k upozornění',
	'Class:SynchroDataSource/Attribute:notify_contact_id+' => '',
	'Class:SynchroDataSource/Attribute:url_icon' => 'Ikona',
	'Class:SynchroDataSource/Attribute:url_icon+' => 'Hypertextový odkaz na ikonu reprezentující aplikaci, se kterou je '.ITOP_APPLICATION_SHORT.' synchronizovnán',
	'Class:SynchroDataSource/Attribute:url_application' => 'Aplikace',
	'Class:SynchroDataSource/Attribute:url_application+' => 'Hypertextový odkaz na '.ITOP_APPLICATION_SHORT.' objekt v externí aplikaci, se kterou je '.ITOP_APPLICATION_SHORT.' synchronizován (pokud je to relevantní). Možné zástupné symboly: $this->attribute$ a $replica->primary_key$',
	'Class:SynchroDataSource/Attribute:reconciliation_policy' => 'Způsob párování',
	'Class:SynchroDataSource/Attribute:reconciliation_policy+' => '"Použijte atribut": '.ITOP_APPLICATION_SHORT.' objekt odpovídá hodnotám replik pro jednotivé atributy synchronizace označené pro odsouhlasení.
"Použít primary_key": sloupec primary_key repliky by měl obsahovat identifikátor objektu '.ITOP_APPLICATION_SHORT.'',
	'Class:SynchroDataSource/Attribute:full_load_periodicity' => 'Interval mezi dvěma kompletními načteními',
	'Class:SynchroDataSource/Attribute:full_load_periodicity+' => 'Kompletní načtení všech dat musí proběhnout nejméně tak často, jak je uvedeno zde',
	'Class:SynchroDataSource/Attribute:action_on_zero' => 'Akce pro nula výsledků',
	'Class:SynchroDataSource/Attribute:action_on_zero+' => 'Jakou akci provést, pokud vyhledávání nevrátí žádný objekt?',
	'Class:SynchroDataSource/Attribute:action_on_one' => 'Akce pro jeden výsledek',
	'Class:SynchroDataSource/Attribute:action_on_one+' => 'Jakou akci provést, pokud vyhledávání vrátí právě jeden objekt?',
	'Class:SynchroDataSource/Attribute:action_on_multiple' => 'Akce pro více výsledků',
	'Class:SynchroDataSource/Attribute:action_on_multiple+' => 'Jakou akci provést, pokud vyhledávání vrátí více než jeden objekt?',
	'Class:SynchroDataSource/Attribute:user_delete_policy' => 'Oprávnění uživatelé',
	'Class:SynchroDataSource/Attribute:user_delete_policy+' => 'Kdo má oprávnění odstraňovat synchronizované objekty',
	'Class:SynchroDataSource/Attribute:delete_policy/Value:never' => 'Nikdo',
	'Class:SynchroDataSource/Attribute:delete_policy/Value:depends' => 'Pouze administrátoři',
	'Class:SynchroDataSource/Attribute:delete_policy/Value:always' => 'Všichni autorizovaní uživatelé',
	'Class:SynchroDataSource/Attribute:delete_policy_update' => 'Aktualizace',
	'Class:SynchroDataSource/Attribute:delete_policy_update+' => 'Formát: field_name:value; ...',
	'Class:SynchroDataSource/Attribute:delete_policy_retention' => 'Doba zachování',
	'Class:SynchroDataSource/Attribute:delete_policy_retention+' => 'V případě, že je nastaveno pravidlo "Aktualizovat a odstranit", zastaralé objekty budou před smazáním zachovány po tuto dobu',
	'Class:SynchroDataSource/Attribute:database_table_name' => 'Tabulka dat',
	'Class:SynchroDataSource/Attribute:database_table_name+' => 'Název tabulky pro ukládání dat z tohoto zdroje. Bude vytvořen automaticky, pokud necháte pole prázdné.',
	'Class:SynchroDataSource/Attribute:status/Value:implementation' => 'Implementace',
	'Class:SynchroDataSource/Attribute:status/Value:obsolete' => 'Zastaralý',
	'Class:SynchroDataSource/Attribute:status/Value:production' => 'V produkci',
	'Class:SynchroDataSource/Attribute:scope_restriction' => 'Omezení rozsahu',
	'Class:SynchroDataSource/Attribute:reconciliation_policy/Value:use_attributes' => 'Použít atributy',
	'Class:SynchroDataSource/Attribute:reconciliation_policy/Value:use_primary_key' => 'Použít pole primary_key',
	'Class:SynchroDataSource/Attribute:action_on_zero/Value:create' => 'Vytvořit nový',
	'Class:SynchroDataSource/Attribute:action_on_zero/Value:error' => 'Chyba',
	'Class:SynchroDataSource/Attribute:action_on_one/Value:error' => 'Chyba',
	'Class:SynchroDataSource/Attribute:action_on_one/Value:update' => 'Aktualizovat',
	'Class:SynchroDataSource/Attribute:action_on_multiple/Value:create' => 'Vytvořit nový',
	'Class:SynchroDataSource/Attribute:action_on_multiple/Value:error' => 'Chyba',
	'Class:SynchroDataSource/Attribute:action_on_multiple/Value:take_first' => 'Vzít první (náhodný?)',
	'Class:SynchroDataSource/Attribute:delete_policy' => 'Pravidla odstraňování',
	'Class:SynchroDataSource/Attribute:delete_policy+' => 'Co mám provést v případě, kdy je replika objektu zastaralá:
"Ignorovat": příslušný objekt zůstane tak jak je.
"Smazat": příslušný objekt (včetně repliky v db) bude smazán.
"Aktualizovat": příslušný objekt bude aktualizován (viz pravidla aktualizace).
"Aktualizovat a následně smazat": aplikuj pravidla pro aktualizaci. Pokud objekt exspiroval, spusť po aktualizaci proces smazání',
	'Class:SynchroDataSource/Attribute:delete_policy/Value:delete' => 'Odstranit',
	'Class:SynchroDataSource/Attribute:delete_policy/Value:ignore' => 'Ignorovat',
	'Class:SynchroDataSource/Attribute:delete_policy/Value:update' => 'Aktualizovat',
	'Class:SynchroDataSource/Attribute:delete_policy/Value:update_then_delete' => 'Aktualizovat a odstranit',
	'Class:SynchroDataSource/Attribute:attribute_list' => 'Seznam atributů',
	'Class:SynchroDataSource/Attribute:user_delete_policy/Value:administrators' => 'Administrátoři',
	'Class:SynchroDataSource/Attribute:user_delete_policy/Value:everybody' => 'Kdokoli',
	'Class:SynchroDataSource/Attribute:user_delete_policy/Value:nobody' => 'Nikdo',
	'SynchroDataSource:Description' => 'Popis',
	'SynchroDataSource:Reconciliation' => 'Hledání a párování',
	'SynchroDataSource:Deletion' => 'Pravidla odstraňování',
	'SynchroDataSource:Status' => 'Stav',
	'SynchroDataSource:Information' => 'Informace',
	'SynchroDataSource:Definition' => 'Definice',
	'Core:SynchroAttributes' => 'Atributy',
	'Core:SynchroStatus' => 'Stav',
	'Core:Synchro:ErrorsLabel' => 'Chyby',
	'Core:Synchro:CreatedLabel' => 'Vytvořen',
	'Core:Synchro:ModifiedLabel' => 'Upraven',
	'Core:Synchro:UnchangedLabel' => 'Nezměněn',
	'Core:Synchro:ReconciledErrorsLabel' => 'Chyby',
	'Core:Synchro:ReconciledLabel' => 'Spárovaný',
	'Core:Synchro:ReconciledNewLabel' => 'Vytvořený',
	'Core:SynchroReconcile:Yes' => 'Ano',
	'Core:SynchroReconcile:No' => 'Ne',
	'Core:SynchroUpdate:Yes' => 'Ano',
	'Core:SynchroUpdate:No' => 'Ne',
	'Core:Synchro:LastestStatus' => 'Poslední stav',
	'Core:Synchro:History' => 'Historie synchronizace',
	'Core:Synchro:NeverRun' => 'Tato synchronizace ještě nebyla spuštěna. Žádné záznamy.',
	'Core:Synchro:SynchroEndedOn_Date' => 'Poslední synchronizace skončila %1$s.',
	'Core:Synchro:SynchroRunningStartedOn_Date' => 'Synchronizace která byla spuštěna %1$s stále běží',
	'Core:Synchro:label_repl_ignored' => 'Ignorovaný (%1$s)',
	'Core:Synchro:label_repl_disappeared' => 'Chybí (%1$s)',
	'Core:Synchro:label_repl_existing' => 'Existující (%1$s)',
	'Core:Synchro:label_repl_new' => 'Nový (%1$s)',
	'Core:Synchro:label_obj_deleted' => 'Odstraněný (%1$s)',
	'Core:Synchro:label_obj_obsoleted' => 'Zastaralý (%1$s)',
	'Core:Synchro:label_obj_disappeared_errors' => 'Chyby (%1$s)',
	'Core:Synchro:label_obj_disappeared_no_action' => 'Žádná akce (%1$s)',
	'Core:Synchro:label_obj_unchanged' => 'Nezměněný (%1$s)',
	'Core:Synchro:label_obj_updated' => 'Aktualizovaný (%1$s)',
	'Core:Synchro:label_obj_updated_errors' => 'Chyby (%1$s)',
	'Core:Synchro:label_obj_new_unchanged' => 'Nezměněný (%1$s)',
	'Core:Synchro:label_obj_new_updated' => 'Aktualizovaný (%1$s)',
	'Core:Synchro:label_obj_created' => 'Vytvořený (%1$s)',
	'Core:Synchro:label_obj_new_errors' => 'Chyby (%1$s)',
	'Core:SynchroLogTitle' => '%1$s - %2$s',
	'Core:Synchro:Nb_Replica' => 'Zpracovaných replik: %1$s',
	'Core:Synchro:Nb_Class:Objects' => '%1$s: %2$s',
	'Class:SynchroDataSource/Error:AtLeastOneReconciliationKeyMustBeSpecified' => 'Musí být uveden alespoň jeden klíč pro párování, nebo musí být vybrán způsob párování "primary_key".',
	'Class:SynchroDataSource/Error:DeleteRetentionDurationMustBeSpecified' => 'Musí být nastavena doba uchování, protože objekty mají být odstraněny poté, co budou označeny jako zastaralé',
	'Class:SynchroDataSource/Error:DeletePolicyUpdateMustBeSpecified' => 'Zastaralé objekty mají být aktualizovány, ale žádná aktualizace není uvedena.',
	'Class:SynchroDataSource/Error:DataTableAlreadyExists' => 'Tabulka %1$s již v databázi existuje. Použijte prosím jiný název.',
	'Core:SynchroReplica:PublicData' => 'Veřejná data',
	'Core:SynchroReplica:PrivateDetails' => 'Interní informace',
	'Core:SynchroReplica:BackToDataSource' => 'Zpět na podrobnosti o zdroji dat: %1$s',
	'Core:SynchroReplica:ListOfReplicas' => 'Seznam replik',
	'Core:SynchroAttExtKey:ReconciliationById' => 'id (primární klíč)',
	'Core:SynchroAtt:attcode' => 'Atribut',
	'Core:SynchroAtt:attcode+' => '',
	'Core:SynchroAtt:reconciliation' => 'Párování ?',
	'Core:SynchroAtt:reconciliation+' => '',
	'Core:SynchroAtt:update' => 'Aktualizovat ?',
	'Core:SynchroAtt:update+' => '',
	'Core:SynchroAtt:update_policy' => 'Pravidla aktualizace',
	'Core:SynchroAtt:update_policy+' => '',
	'Core:SynchroAtt:reconciliation_attcode' => 'Klíč pro párování',
	'Core:SynchroAtt:reconciliation_attcode+' => 'Kód atributu pro externí klíč párování',
	'Core:SyncDataExchangeComment' => '(Synchronizace dat)',
	'Core:Synchro:ListOfDataSources' => 'Seznam zdrojů dat:',
	'Core:Synchro:LastSynchro' => 'Poslední synchronizace:',
	'Core:Synchro:ThisObjectIsSynchronized' => 'Tento objekt je synchronizován s externím zdrojem dat',
	'Core:Synchro:TheObjectWasCreatedBy_Source' => 'Tento objekt byl <strong>vytvořen</strong> externím zdrojem dat %1$s',
	'Core:Synchro:TheObjectCanBeDeletedBy_Source' => 'Tento objekt <strong>může být odstraněn</strong> externím zdrojem dat %1$s',
	'Core:Synchro:TheObjectCannotBeDeletedByUser_Source' => '<strong>Nemůžete odstranit tento objekt</strong>, protože je vlastněn externím zdrojem dat %1$s',
	'TitleSynchroExecution' => 'Provádění synchronizace',
	'Class:SynchroDataSource:DataTable' => 'Databázová tabulka: %1$s',
	'Core:SyncDataSourceObsolete' => 'Zdroj dat je označený jako zastaralý. Operace byla zrušena.',
	'Core:SyncDataSourceAccessRestriction' => 'Pouze administrátoři nebo uživatelé uvedení ve zdroji dat mohou provádět tuto operaci. Operace byla zrušena.',
	'Core:SyncTooManyMissingReplicas' => 'Všechny záznamy nebyly nějakou chvíli aktualizovány, všechny objekty mohou být smazány. Zkontrolujte prosím funkčnost synchronizace. Operace byla zrušena.',
	'Core:SyncSplitModeCLIOnly' => 'Synchronizace může být provádena v blocích pouze při použití modulu CLI',
	'Core:Synchro:ListReplicas_AllReplicas_Errors_Warnings' => '%1$s replik, %2$s chyb, %3$s varování.',
	'Core:SynchroReplica:TargetObject' => 'Synchronizované objekty: %1$s',
	'Class:AsyncSendEmail' => 'Email (asynchronní)',
	'Class:AsyncSendEmail/Attribute:to' => 'Adresát',
	'Class:AsyncSendEmail/Attribute:subject' => 'Předmět',
	'Class:AsyncSendEmail/Attribute:body' => 'Tělo',
	'Class:AsyncSendEmail/Attribute:header' => 'Hlavička',
	'Class:CMDBChangeOpSetAttributeOneWayPassword' => 'Šifrované heslo',
	'Class:CMDBChangeOpSetAttributeOneWayPassword/Attribute:prev_pwd' => 'Předchozí hodnota',
	'Class:CMDBChangeOpSetAttributeEncrypted' => 'Šifrované pole',
	'Class:CMDBChangeOpSetAttributeEncrypted/Attribute:prevstring' => 'Předchozí hodnota',
	'Class:CMDBChangeOpSetAttributeCaseLog' => 'Protokol událostí',
	'Class:CMDBChangeOpSetAttributeCaseLog/Attribute:lastentry' => 'Poslední záznam',
	'Class:SynchroAttribute' => 'Atribut pro synchronizaci',
	'Class:SynchroAttribute/Attribute:sync_source_id' => 'Zdroj dat pro synchronizaci',
	'Class:SynchroAttribute/Attribute:attcode' => 'Kód atributu',
	'Class:SynchroAttribute/Attribute:update' => 'Aktualizace',
	'Class:SynchroAttribute/Attribute:reconcile' => 'Párování',
	'Class:SynchroAttribute/Attribute:update_policy' => 'Pravidla aktualizace',
	'Class:SynchroAttribute/Attribute:update_policy/Value:master_locked' => 'Uzamčen',
	'Class:SynchroAttribute/Attribute:update_policy/Value:master_unlocked' => 'Odemčen',
	'Class:SynchroAttribute/Attribute:update_policy/Value:write_if_empty' => 'Zapsat pokud je prázdný',
	'Class:SynchroAttribute/Attribute:finalclass' => 'Třída',
	'Class:SynchroAttExtKey' => 'Atribut synchronizace (externí klíč)',
	'Class:SynchroAttExtKey/Attribute:reconciliation_attcode' => 'Atribut pro párování',
	'Class:SynchroAttLinkSet' => 'Atribut synchronizace (Linkset)',
	'Class:SynchroAttLinkSet/Attribute:row_separator' => 'Oddělovač řádků',
	'Class:SynchroAttLinkSet/Attribute:attribute_separator' => 'Oddělovač atributů',
	'Class:SynchroLog' => 'Protokol synchronizací',
	'Class:SynchroLog/Attribute:sync_source_id' => 'Zdroj dat pro synchronizaci',
	'Class:SynchroLog/Attribute:start_date' => 'Datum zahájení',
	'Class:SynchroLog/Attribute:end_date' => 'Datum ukončení',
	'Class:SynchroLog/Attribute:status' => 'Stav',
	'Class:SynchroLog/Attribute:status/Value:completed' => 'Dokončeno',
	'Class:SynchroLog/Attribute:status/Value:error' => 'Chyba',
	'Class:SynchroLog/Attribute:status/Value:running' => 'Stále běží',
	'Class:SynchroLog/Attribute:stats_nb_replica_seen' => 'Počet replik dostupných',
	'Class:SynchroLog/Attribute:stats_nb_replica_total' => 'Počet replik celkem',
	'Class:SynchroLog/Attribute:stats_nb_obj_deleted' => 'Podčet odstraněných objektů',
	'Class:SynchroLog/Attribute:stats_nb_obj_deleted_errors' => 'Počet chyb při odstraňování',
	'Class:SynchroLog/Attribute:stats_nb_obj_obsoleted' => 'Počet zastaralých objektů',
	'Class:SynchroLog/Attribute:stats_nb_obj_obsoleted_errors' => 'Počet chyb při zastarávání',
	'Class:SynchroLog/Attribute:stats_nb_obj_created' => 'Počet vytvořených objektů',
	'Class:SynchroLog/Attribute:stats_nb_obj_created_errors' => 'Počet chyb při vytváření',
	'Class:SynchroLog/Attribute:stats_nb_obj_updated' => 'Počet aktualizovaných objektů',
	'Class:SynchroLog/Attribute:stats_nb_obj_updated_errors' => 'Počet chyb při aktualizaci',
	'Class:SynchroLog/Attribute:stats_nb_replica_reconciled_errors' => 'Počet chyb při sladění',
	'Class:SynchroLog/Attribute:stats_nb_replica_disappeared_no_action' => 'Počet zmizelých replik',
	'Class:SynchroLog/Attribute:stats_nb_obj_new_updated' => 'Počet aktualizovaných objektů',
	'Class:SynchroLog/Attribute:stats_nb_obj_new_unchanged' => 'Počet nezměněných objektů',
	'Class:SynchroLog/Attribute:last_error' => 'Poslední chyba',
	'Class:SynchroLog/Attribute:traces' => 'Stopy',
	'Class:SynchroReplica' => 'Synchronizace replik',
	'Class:SynchroReplica/Attribute:sync_source_id' => 'Zdroj dat pro synchronizaci',
	'Class:SynchroReplica/Attribute:dest_id' => 'Cílový objekt (ID)',
	'Class:SynchroReplica/Attribute:dest_class' => 'Cílový typ',
	'Class:SynchroReplica/Attribute:status_last_seen' => 'Naposledy viděn',
	'Class:SynchroReplica/Attribute:status' => 'Stav',
	'Class:SynchroReplica/Attribute:status/Value:modified' => 'Upraven',
	'Class:SynchroReplica/Attribute:status/Value:new' => 'Nový',
	'Class:SynchroReplica/Attribute:status/Value:obsolete' => 'Zastaralý',
	'Class:SynchroReplica/Attribute:status/Value:orphan' => 'Sirotek',
	'Class:SynchroReplica/Attribute:status/Value:synchronized' => 'Synchronizovaný',
	'Class:SynchroReplica/Attribute:status_dest_creator' => 'Generovaný objekt?',
	'Class:SynchroReplica/Attribute:status_last_error' => 'Poslední chyba',
	'Class:SynchroReplica/Attribute:status_last_warning' => 'Poslední varování',
	'Class:SynchroReplica/Attribute:info_creation_date' => 'Datum vytvoření',
	'Class:SynchroReplica/Attribute:info_last_modified' => 'Datum poslední úpravy',
	'Class:appUserPreferences' => 'Uživatelské předvolby',
	'Class:appUserPreferences/Attribute:userid' => 'Uživatel',
	'Class:appUserPreferences/Attribute:preferences' => 'Předvolby',
	'Core:ExecProcess:Code1' => 'Chybní příkaz, nebo příkaz skončil s chybou (např chybný název skriptu)',
	'Core:ExecProcess:Code255' => 'PHP Error (parsing/runtime)',
	'Core:Duration_Seconds' => '%1$ds',
	'Core:Duration_Minutes_Seconds' => '%1$dmin %2$ds',
	'Core:Duration_Hours_Minutes_Seconds' => '%1$dh %2$dmin %3$ds',
	'Core:Duration_Days_Hours_Minutes_Seconds' => '%1$sd %2$dh %3$dmin %4$ds',
	'Core:ExplainWTC:ElapsedTime' => 'Uplynulý čas ("%1$s")',
	'Core:ExplainWTC:StopWatch-TimeSpent' => 'Čas strávený na "%1$s"',
	'Core:ExplainWTC:StopWatch-Deadline' => 'Uzávěrka pro "%1$s" v %2$d%%',
	'Core:BulkExport:MissingParameter_Param' => 'Chybějící parametr "%1$s"',
	'Core:BulkExport:InvalidParameter_Query' => 'Chybná hodnota parametru "query". Neznám žádný záznam odpovídající následujícímu id: "%1$s".',
	'Core:BulkExport:ExportFormatPrompt' => 'Formát exportu:',
	'Core:BulkExportOf_Class' => '%1$s_export',
	'Core:BulkExport:ClickHereToDownload_FileName' => 'Klikněte pro stažení souboru %1$s',
	'Core:BulkExport:ExportResult' => 'Výsledek exportu:',
	'Core:BulkExport:RetrievingData' => 'Zízkávám data...',
	'Core:BulkExport:HTMLFormat' => 'HTML stránka (*.html)',
	'Core:BulkExport:CSVFormat' => 'Hodnoty oddělené čárkami (*.csv)',
	'Core:BulkExport:XLSXFormat' => 'Excel 2007 a novější (*.xlsx)',
	'Core:BulkExport:PDFFormat' => 'PDF dokument (*.pdf)',
	'Core:BulkExport:DragAndDropHelp' => 'Přesuňte sloupce uchopením za jejich hlavičku. Náhled prvních %1$s řádků. Celkový počet řádků k exportu: %2$s.',
	'Core:BulkExport:EmptyPreview' => 'Vyberte sloupce k exportu ze seznamu',
	'Core:BulkExport:ColumnsOrder' => 'Pořadí sloupců',
	'Core:BulkExport:AvailableColumnsFrom_Class' => 'Dostupné sloupce pro třídu %1$s',
	'Core:BulkExport:NoFieldSelected' => 'Označte alespoň jeden sloupec k exportu',
	'Core:BulkExport:CheckAll' => 'Označit vše',
	'Core:BulkExport:UncheckAll' => 'Odznačit vše',
	'Core:BulkExport:ExportCancelledByUser' => 'Export přerušen uživatelem',
	'Core:BulkExport:CSVOptions' => 'Možnosti CSV',
	'Core:BulkExport:CSVLocalization' => 'Lokalizace',
	'Core:BulkExport:PDFOptions' => 'Možnosti PDF',
	'Core:BulkExport:PDFPageFormat' => 'Formát stránky',
	'Core:BulkExport:PDFPageSize' => 'Velikost stránky:',
	'Core:BulkExport:PageSize-A4' => 'A4',
	'Core:BulkExport:PageSize-A3' => 'A3',
	'Core:BulkExport:PageSize-Letter' => 'Letter',
	'Core:BulkExport:PDFPageOrientation' => 'Orientace stránky:',
	'Core:BulkExport:PageOrientation-L' => 'Na šířku',
	'Core:BulkExport:PageOrientation-P' => 'Na výšku',
	'Core:BulkExport:XMLFormat' => 'XML soubor (*.xml)',
	'Core:BulkExport:XMLOptions' => 'Možnosti XML',
	'Core:BulkExport:SpreadsheetFormat' => 'HTML tabulka (*.html)',
	'Core:BulkExport:SpreadsheetOptions' => 'Možnosti tabulky',
	'Core:BulkExport:OptionNoLocalize' => 'Nepřekládat hodnoty číselníků',
	'Core:BulkExport:OptionLinkSets' => 'Zahrnout odkazované objekty',
	'Core:BulkExport:OptionFormattedText' => 'Zachovat formátování textu',
	'Core:BulkExport:ScopeDefinition' => 'Definice objektů k exportu',
	'Core:BulkExportLabelOQLExpression' => 'Dotaz OQL:',
	'Core:BulkExportLabelPhrasebookEntry' => 'Záznam v knihovně dotazů:',
	'Core:BulkExportMessageEmptyOQL' => 'Zadejte platný OQL dotaz.',
	'Core:BulkExportMessageEmptyPhrasebookEntry' => 'Prosím vyberte platnou položku ze slovníku příkazů',
	'Core:BulkExportQueryPlaceholder' => 'Zde zadejte OQL dotaz...',
	'Core:BulkExportCanRunNonInteractive' => 'Klikni zde pro spuštění exportu v neinteraktivním režimu',
	'Core:BulkExportLegacyExport' => 'Původní verze exportu',
	'Core:BulkExport:XLSXOptions' => 'Nastavení pro Excel',
	'Core:BulkExport:TextFormat' => 'Textová pole obsahující HTML kód',
	'Core:BulkExport:DateTimeFormat' => 'Formát datumu a času',
	'Core:BulkExport:DateTimeFormatDefault_Example' => 'Základní formát (%1$s), e.g. %2$s',
	'Core:BulkExport:DateTimeFormatCustom_Format' => 'Vlastní formát: %1$s',
	'Core:BulkExport:PDF:PageNumber' => 'Stránka %1$s',
	'Core:DateTime:Placeholder_d' => 'DD',
	'Core:DateTime:Placeholder_j' => 'D',
	'Core:DateTime:Placeholder_m' => 'MM',
	'Core:DateTime:Placeholder_n' => 'M',
	'Core:DateTime:Placeholder_Y' => 'RRRR',
	'Core:DateTime:Placeholder_y' => 'RR',
	'Core:DateTime:Placeholder_H' => 'hh',
	'Core:DateTime:Placeholder_h' => 'h',
	'Core:DateTime:Placeholder_G' => 'hh',
	'Core:DateTime:Placeholder_g' => 'h',
	'Core:DateTime:Placeholder_a' => 'am/pm',
	'Core:DateTime:Placeholder_A' => 'AM/PM',
	'Core:DateTime:Placeholder_i' => 'mm',
	'Core:DateTime:Placeholder_s' => 'ss',
	'Core:Validator:Default' => 'Nesprávný formát',
	'Core:Validator:Mandatory' => 'Vyplňte prosím toto pole',
	'Core:Validator:MustBeInteger' => 'Musí být celé číslo',
	'Core:Validator:MustSelectOne' => 'Zvolte prosím jednu hodnotu',
	'Menu:DataSources' => 'Zdroje dat pro synchronizaci',
	'Menu:DataSources+' => 'Všechny zdroje dat pro synchronizaci'
));

//
// Class: TagSetFieldData
//
Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:TagSetFieldData' => '%2$s pro třídu %1$s',
	'Class:TagSetFieldData+' => '',
	'Class:TagSetFieldData/Attribute:code' => 'Kód',
	'Class:TagSetFieldData/Attribute:code+' => 'Interní kód musí obsahovat minimálně 3 alfanumerické znaky',
	'Class:TagSetFieldData/Attribute:label' => 'Označení',
	'Class:TagSetFieldData/Attribute:label+' => 'Zobrazované označení',
	'Class:TagSetFieldData/Attribute:description' => 'Popis',
	'Class:TagSetFieldData/Attribute:description+' => '',
	'Class:TagSetFieldData/Attribute:finalclass' => 'Třída tagů',
	'Class:TagSetFieldData/Attribute:obj_class' => 'Třída objektů',
	'Class:TagSetFieldData/Attribute:obj_attcode' => 'Pole kódu',
	'Core:TagSetFieldData:ErrorDeleteUsedTag' => 'Používaný tag nemůže být smazán',
	'Core:TagSetFieldData:ErrorDuplicateTagCodeOrLabel' => 'Tag i Označení musí být unikátní',
	'Core:TagSetFieldData:ErrorTagCodeSyntax' => 'Tag musí obsahovat 3 až %1$d alfanumerické znaky',
	'Core:TagSetFieldData:ErrorTagCodeReservedWord' => 'Zvolený Tag patří mezi rezerované tagy',
	'Core:TagSetFieldData:ErrorTagLabelSyntax' => 'Označení Tagu nesmí obsahovat \'%1$s\' nebo být prázdný',
	'Core:TagSetFieldData:ErrorCodeUpdateNotAllowed' => 'Používaný tag nemůže být změněn',
	'Core:TagSetFieldData:ErrorClassUpdateNotAllowed' => 'Třída objektu Tag nemůže být změněna',
	'Core:TagSetFieldData:ErrorAttCodeUpdateNotAllowed' => 'Atribut kód u Tagu nemůže být změněn',
	'Core:TagSetFieldData:WhereIsThisTagTab' => 'Použití Tagu (%1$d)',
	'Core:TagSetFieldData:NoEntryFound' => 'Pro Tag nebyl nalezen žádný vstup',
));

//
// Class: DBProperty
//
Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:DBProperty' => 'Nastavení DB',
	'Class:DBProperty+' => '',
	'Class:DBProperty/Attribute:name' => 'Jméno',
	'Class:DBProperty/Attribute:name+' => '',
	'Class:DBProperty/Attribute:description' => 'Popis',
	'Class:DBProperty/Attribute:description+' => '',
	'Class:DBProperty/Attribute:value' => 'Hodnota',
	'Class:DBProperty/Attribute:value+' => '',
	'Class:DBProperty/Attribute:change_date' => 'Změna datumu',
	'Class:DBProperty/Attribute:change_date+' => '',
	'Class:DBProperty/Attribute:change_comment' => 'Změna komentáře',
	'Class:DBProperty/Attribute:change_comment+' => '',
));

//
// Class: BackgroundTask
//
Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:BackgroundTask' => 'Úkoly běžící na pozadí',
	'Class:BackgroundTask+' => '',
	'Class:BackgroundTask/Attribute:class_name' => 'Jméno třídy',
	'Class:BackgroundTask/Attribute:class_name+' => '',
	'Class:BackgroundTask/Attribute:first_run_date' => 'Datum prvního spuštění',
	'Class:BackgroundTask/Attribute:first_run_date+' => '',
	'Class:BackgroundTask/Attribute:latest_run_date' => 'Datum posledního spuštění',
	'Class:BackgroundTask/Attribute:latest_run_date+' => '',
	'Class:BackgroundTask/Attribute:next_run_date' => 'Datum dalšího spuštění',
	'Class:BackgroundTask/Attribute:next_run_date+' => '',
	'Class:BackgroundTask/Attribute:total_exec_count' => 'Počet spuštění:',
	'Class:BackgroundTask/Attribute:total_exec_count+' => '',
	'Class:BackgroundTask/Attribute:latest_run_duration' => 'Délka posledního běhu',
	'Class:BackgroundTask/Attribute:latest_run_duration+' => '',
	'Class:BackgroundTask/Attribute:min_run_duration' => 'Min. délka běhu',
	'Class:BackgroundTask/Attribute:min_run_duration+' => '',
	'Class:BackgroundTask/Attribute:max_run_duration' => 'Max. délka běhu',
	'Class:BackgroundTask/Attribute:max_run_duration+' => '',
	'Class:BackgroundTask/Attribute:average_run_duration' => 'Průměrná délka běhu',
	'Class:BackgroundTask/Attribute:average_run_duration+' => '',
	'Class:BackgroundTask/Attribute:running' => 'Spuštěno',
	'Class:BackgroundTask/Attribute:running+' => '',
	'Class:BackgroundTask/Attribute:status' => 'Status',
	'Class:BackgroundTask/Attribute:status+' => '',
));

//
// Class: AsyncTask
//
Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:AsyncTask' => 'Asynchronní úkoly',
	'Class:AsyncTask+' => '',
	'Class:AsyncTask/Attribute:created' => 'Vytvořeno',
	'Class:AsyncTask/Attribute:created+' => '',
	'Class:AsyncTask/Attribute:started' => 'Spuštěno',
	'Class:AsyncTask/Attribute:started+' => '',
	'Class:AsyncTask/Attribute:planned' => 'Naplánováno',
	'Class:AsyncTask/Attribute:planned+' => '',
	'Class:AsyncTask/Attribute:event_id' => 'Událost',
	'Class:AsyncTask/Attribute:event_id+' => '',
	'Class:AsyncTask/Attribute:finalclass' => 'Cílová třída',
	'Class:AsyncTask/Attribute:finalclass+' => '',
	'Class:AsyncTask/Attribute:status' => 'Status',
	'Class:AsyncTask/Attribute:status+' => '',
	'Class:AsyncTask/Attribute:remaining_retries' => 'Zbývající pokusy',
	'Class:AsyncTask/Attribute:remaining_retries+' => '',
	'Class:AsyncTask/Attribute:last_error_code' => 'Poslední chybový kód',
	'Class:AsyncTask/Attribute:last_error_code+' => '',
	'Class:AsyncTask/Attribute:last_error' => 'Poslední chyba',
	'Class:AsyncTask/Attribute:last_error+' => '',
	'Class:AsyncTask/Attribute:last_attempt' => 'Poslední pokus',
	'Class:AsyncTask/Attribute:last_attempt+' => '',
	'Class:AsyncTask:InvalidConfig_Class_Keys' => 'Špatný formát pro nastavení "async_task_retries[%1$s]". Je očekáváno pole obsahující následující klíče: %2$s',
	'Class:AsyncTask:InvalidConfig_Class_InvalidKey_Keys' => 'Špatný formát pro nastavení "async_task_retries[%1$s]": neočekávaný klíč "%2$s". Je očekáván jeden z následujících klíčů: %3$s',
));

//
// Class: AbstractResource
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:AbstractResource' => 'Abstraktní zdroj',
	'Class:AbstractResource+' => '',
));

//
// Class: ResourceAdminMenu
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:ResourceAdminMenu' => 'Resource Admin Menu~~',
	'Class:ResourceAdminMenu+' => '',
));

//
// Class: ResourceRunQueriesMenu
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:ResourceRunQueriesMenu' => 'Resource Run Queries Menu~~',
	'Class:ResourceRunQueriesMenu+' => '',
));

//
// Class: Action
//

Dict::Add('CS CZ', 'Czech', 'Čeština', array(
	'Class:ResourceSystemMenu' => 'Resource System Menu~~',
	'Class:ResourceSystemMenu+' => '',
));



