<?php
/**
 * Spanish Localized data
 *
 * @copyright Copyright (C) 2010-2024 Combodo SAS
 * @license    https://opensource.org/licenses/AGPL-3.0
 * @author Miguel Turrubiates <miguel_tf@yahoo.com>
 * @notas       Utilizar codificación UTF-8 para mostrar acentos y otros caracteres especiales 
 */
Dict::Add('ES CR', 'Spanish', 'Español, Castellano', array(
	'Class:Ticket' => 'Ticket',
	'Class:Ticket+' => 'Ticket',
	'Class:Ticket/Attribute:ref' => 'Ref',
	'Class:Ticket/Attribute:ref+' => 'Ref',
	'Class:Ticket/Attribute:org_id' => 'Organización',
	'Class:Ticket/Attribute:org_id+' => 'Organización',
	'Class:Ticket/Attribute:org_name' => 'Organización',
	'Class:Ticket/Attribute:org_name+' => 'Organización',
	'Class:Ticket/Attribute:caller_id' => 'Reportado por',
	'Class:Ticket/Attribute:caller_id+' => 'Reportado por',
	'Class:Ticket/Attribute:caller_name' => 'Reportado por',
	'Class:Ticket/Attribute:caller_name+' => 'Reportado por',
	'Class:Ticket/Attribute:team_id' => 'Grupo',
	'Class:Ticket/Attribute:team_id+' => 'Grupo',
	'Class:Ticket/Attribute:team_name' => 'Grupo de Trabajo',
	'Class:Ticket/Attribute:team_name+' => 'Grupo de Trabajo',
	'Class:Ticket/Attribute:agent_id' => 'Analista',
	'Class:Ticket/Attribute:agent_id+' => 'Analista',
	'Class:Ticket/Attribute:agent_name' => 'Analista',
	'Class:Ticket/Attribute:agent_name+' => 'Analista',
	'Class:Ticket/Attribute:title' => 'Asunto',
	'Class:Ticket/Attribute:title+' => 'Asunto',
	'Class:Ticket/Attribute:description' => 'Descripción',
	'Class:Ticket/Attribute:description+' => 'Descripción',
	'Class:Ticket/Attribute:start_date' => 'Fecha de Inicio',
	'Class:Ticket/Attribute:start_date+' => 'Fecha de Inicio',
	'Class:Ticket/Attribute:end_date' => 'Fecha de Fin',
	'Class:Ticket/Attribute:end_date+' => 'Fecha de Fin',
	'Class:Ticket/Attribute:last_update' => 'Última Actualización',
	'Class:Ticket/Attribute:last_update+' => 'Última Actualización',
	'Class:Ticket/Attribute:close_date' => 'Fecha de Cierre',
	'Class:Ticket/Attribute:close_date+' => 'Fecha de Cierre',
	'Class:Ticket/Attribute:private_log' => 'Bitácora Privada',
	'Class:Ticket/Attribute:private_log+' => 'Bitácora Privada',
	'Class:Ticket/Attribute:contacts_list' => 'Contactos',
	'Class:Ticket/Attribute:contacts_list+' => 'Contactos',
	'Class:Ticket/Attribute:functionalcis_list' => 'ECs',
	'Class:Ticket/Attribute:functionalcis_list+' => 'Elementos de Configuración',
	'Class:Ticket/Attribute:workorders_list' => 'Ordenes de Trabajo',
	'Class:Ticket/Attribute:workorders_list+' => 'Ordenes de Trabajo',
	'Class:Ticket/Attribute:finalclass' => 'Clase',
	'Class:Ticket/Attribute:finalclass+' => 'Clase',
	'Class:Ticket/Attribute:operational_status' => 'Estatus Operativo',
	'Class:Ticket/Attribute:operational_status+' => 'Calculado despues del status detallado',
	'Class:Ticket/Attribute:operational_status/Value:ongoing' => 'En Proceso',
	'Class:Ticket/Attribute:operational_status/Value:ongoing+' => 'En Proceso',
	'Class:Ticket/Attribute:operational_status/Value:resolved' => 'Solucionado',
	'Class:Ticket/Attribute:operational_status/Value:resolved+' => 'Solucionado',
	'Class:Ticket/Attribute:operational_status/Value:closed' => 'Cerrado',
	'Class:Ticket/Attribute:operational_status/Value:closed+' => 'Cerrado',
	'Ticket:ImpactAnalysis' => 'Análisis de Impacto',
));


//
// Class: lnkContactToTicket
//

Dict::Add('ES CR', 'Spanish', 'Español, Castellano', array(
	'Class:lnkContactToTicket' => 'Relación Contacto y Ticket',
	'Class:lnkContactToTicket+' => 'Relación Contacto y Ticket',
	'Class:lnkContactToTicket/Name' => '%1$s / %2$s',
	'Class:lnkContactToTicket/Attribute:ticket_id' => 'Ticket',
	'Class:lnkContactToTicket/Attribute:ticket_id+' => 'Ticket',
	'Class:lnkContactToTicket/Attribute:ticket_ref' => 'Ref',
	'Class:lnkContactToTicket/Attribute:ticket_ref+' => 'Ref',
	'Class:lnkContactToTicket/Attribute:contact_id' => 'Contacto',
	'Class:lnkContactToTicket/Attribute:contact_id+' => 'Contacto',
	'Class:lnkContactToTicket/Attribute:contact_name' => 'Nombre',
	'Class:lnkContactToTicket/Attribute:contact_name+' => 'Nombre',
	'Class:lnkContactToTicket/Attribute:contact_email' => 'Correo Electrónico',
	'Class:lnkContactToTicket/Attribute:contact_email+' => 'Correo Electrónico',
	'Class:lnkContactToTicket/Attribute:role' => 'Rol',
	'Class:lnkContactToTicket/Attribute:role+' => 'Rol',
	'Class:lnkContactToTicket/Attribute:role_code' => 'Rol',
	'Class:lnkContactToTicket/Attribute:role_code/Value:manual' => 'Agregado Manualmente',
	'Class:lnkContactToTicket/Attribute:role_code/Value:computed' => 'Calculado',
	'Class:lnkContactToTicket/Attribute:role_code/Value:do_not_notify' => 'No notificar',
));

//
// Class: WorkOrder
//

Dict::Add('ES CR', 'Spanish', 'Español, Castellano', array(
	'Class:WorkOrder' => 'Orden de Trabajo',
	'Class:WorkOrder+' => 'Orden de Trabajo',
	'Class:WorkOrder/Attribute:name' => 'Nombre',
	'Class:WorkOrder/Attribute:name+' => 'Nombre de la Orden de Trabajo',
	'Class:WorkOrder/Attribute:status' => 'Estatus',
	'Class:WorkOrder/Attribute:status+' => 'Estatus',
	'Class:WorkOrder/Attribute:status/Value:open' => 'Abierto',
	'Class:WorkOrder/Attribute:status/Value:open+' => 'Abierto',
	'Class:WorkOrder/Attribute:status/Value:closed' => 'Cerrado',
	'Class:WorkOrder/Attribute:status/Value:closed+' => 'Cerrado',
	'Class:WorkOrder/Attribute:description' => 'Descripción',
	'Class:WorkOrder/Attribute:description+' => 'Descripción',
	'Class:WorkOrder/Attribute:ticket_id' => 'Ticket',
	'Class:WorkOrder/Attribute:ticket_id+' => 'Ticket',
	'Class:WorkOrder/Attribute:ticket_ref' => 'Ref. Ticket',
	'Class:WorkOrder/Attribute:ticket_ref+' => 'Ref. Ticket',
	'Class:WorkOrder/Attribute:team_id' => 'Grupo',
	'Class:WorkOrder/Attribute:team_id+' => 'Grupo',
	'Class:WorkOrder/Attribute:team_name' => 'Grupo de Trabajo',
	'Class:WorkOrder/Attribute:team_name+' => 'Grupo de Trabajo',
	'Class:WorkOrder/Attribute:agent_id' => 'Analista',
	'Class:WorkOrder/Attribute:agent_id+' => 'Analista',
	'Class:WorkOrder/Attribute:agent_email' => 'Correo Electrónico del Analista',
	'Class:WorkOrder/Attribute:agent_email+' => 'Correo Electrónico del Analista',
	'Class:WorkOrder/Attribute:start_date' => 'Fecha de Inicio',
	'Class:WorkOrder/Attribute:start_date+' => 'Fecha de Inicio',
	'Class:WorkOrder/Attribute:end_date' => 'Fecha de Fin',
	'Class:WorkOrder/Attribute:end_date+' => 'Fecha de Fin',
	'Class:WorkOrder/Attribute:log' => 'Bitácora',
	'Class:WorkOrder/Attribute:log+' => 'Bitácora',
	'Class:WorkOrder/Stimulus:ev_close' => 'Cerrar',
	'Class:WorkOrder/Stimulus:ev_close+' => 'Cerrar',
));


// Fieldset translation
Dict::Add('ES CR', 'Spanish', 'Español, Castellano', array(
	'Ticket:baseinfo' => 'Información General',
	'Ticket:date' => 'Fechas',
	'Ticket:contact' => 'Contactos',
	'Ticket:moreinfo' => 'Más Información',
	'Ticket:relation' => 'Relaciones',
	'Ticket:log' => 'Comunicaciones',
	'Ticket:Type' => 'Clasificación',
	'Ticket:support' => 'Soporte',
	'Ticket:resolution' => 'Solución',
	'Ticket:SLA' => 'Reporte de SLA',
	'WorkOrder:Details' => 'Detalles',
	'WorkOrder:Moreinfo' => 'Más Información',
	'Tickets:ResolvedFrom' => 'Automáticamente resuelto de %1$s',
	'Class:cmdbAbstractObject/Method:Set' => 'Asignar',
	'Class:cmdbAbstractObject/Method:Set+' => 'Asignar campo con valor estático',
	'Class:cmdbAbstractObject/Method:Set/Param:1' => 'Campo Destino',
	'Class:cmdbAbstractObject/Method:Set/Param:1+' => 'El campo a asignar, en el objeto actual',
	'Class:cmdbAbstractObject/Method:Set/Param:2' => 'Valor',
	'Class:cmdbAbstractObject/Method:Set/Param:2+' => 'Valor a asignar',
	'Class:cmdbAbstractObject/Method:SetCurrentDate' => 'Asignar fecha actual',
	'Class:cmdbAbstractObject/Method:SetCurrentDate+' => 'Asignar fecha y hora actuales',
	'Class:cmdbAbstractObject/Method:SetCurrentDate/Param:1' => 'Campo Destino',
	'Class:cmdbAbstractObject/Method:SetCurrentDate/Param:1+' => 'El campo a asignar, en el objeto actual',
	'Class:cmdbAbstractObject/Method:SetCurrentDateIfNull' => 'Establecer fecha actual si es nulo',
	'Class:cmdbAbstractObject/Method:SetCurrentDateIfNull+' => 'Establecer un campo vacío con la fecha y hora actuales',
	'Class:cmdbAbstractObject/Method:SetCurrentDateIfNull/Param:1' => 'Campo objetivo',
	'Class:cmdbAbstractObject/Method:SetCurrentDateIfNull/Param:1+' => 'El campo a configurar, en el objeto actual',
	'Class:cmdbAbstractObject/Method:SetCurrentUser' => 'Asignar Usuario actual',
	'Class:cmdbAbstractObject/Method:SetCurrentUser+' => 'Asignar Usuario actual',
	'Class:cmdbAbstractObject/Method:SetCurrentUser/Param:1' => 'Campo Destino',
	'Class:cmdbAbstractObject/Method:SetCurrentUser/Param:1+' => 'Si el campo es una cadena de caracteres, entonces el nombre completo será usado, de otra manera el identificador será usado. El nombre completo es el nombre de una persona que está ligado a un usurio, si no será su clave de acceso.',
	'Class:cmdbAbstractObject/Method:SetCurrentPerson' => 'Asignar Persona actual',
	'Class:cmdbAbstractObject/Method:SetCurrentPerson+' => 'Asignar Persona actual',
	'Class:cmdbAbstractObject/Method:SetCurrentPerson/Param:1' => 'Campo Destino',
	'Class:cmdbAbstractObject/Method:SetCurrentPerson/Param:1+' => 'Si el campo es una cadena de caracteres, entonces el nombre completo será usado, de otra manera el identificador será usado.',
	'Class:cmdbAbstractObject/Method:SetElapsedTime' => 'Asignar tiempo transcurrido',
	'Class:cmdbAbstractObject/Method:SetElapsedTime+' => 'Asignar tiempo transcurrido (segundos)',
	'Class:cmdbAbstractObject/Method:SetElapsedTime/Param:1' => 'Campo Destino',
	'Class:cmdbAbstractObject/Method:SetElapsedTime/Param:1+' => 'El campo a configurar, en el objeto actual',
	'Class:cmdbAbstractObject/Method:SetElapsedTime/Param:2' => 'Campo de Referencia',
	'Class:cmdbAbstractObject/Method:SetElapsedTime/Param:2+' => 'El campo desde el que se obtienen los datos referenciados',
	'Class:cmdbAbstractObject/Method:SetElapsedTime/Param:3' => 'Horas Trabajadas',
	'Class:cmdbAbstractObject/Method:SetElapsedTime/Param:3+' => 'Dejar vacio para utilizar el horario de trabajo estandar, o dejar por omisión para usar esquema 7x24',
	'Class:cmdbAbstractObject/Method:SetIfNull' => 'Establecer si es nulo',
	'Class:cmdbAbstractObject/Method:SetIfNull+' => 'Establecer un campo sólo si está vacío, con un valor estático',
	'Class:cmdbAbstractObject/Method:SetIfNull/Param:1' => 'Campo objetivo',
	'Class:cmdbAbstractObject/Method:SetIfNull/Param:1+' => 'El campo a configurar, en el objeto actual',
	'Class:cmdbAbstractObject/Method:SetIfNull/Param:2' => 'Valor',
	'Class:cmdbAbstractObject/Method:SetIfNull/Param:2+' => 'El valor a establecer',
	'Class:cmdbAbstractObject/Method:AddValue' => 'Agregar Valor',
	'Class:cmdbAbstractObject/Method:AddValue+' => 'Agregar un valor fijo a un campo',
	'Class:cmdbAbstractObject/Method:AddValue/Param:1' => 'Campo objetivo',
	'Class:cmdbAbstractObject/Method:AddValue/Param:1+' => 'El campo a modificar, en el objeto actual.',
	'Class:cmdbAbstractObject/Method:AddValue/Param:2' => 'Valor',
	'Class:cmdbAbstractObject/Method:AddValue/Param:2+' => 'El valor decimal que se sumará puede ser negativo.',
	'Class:cmdbAbstractObject/Method:SetComputedDate' => 'Establecer fecha calculada',
	'Class:cmdbAbstractObject/Method:SetComputedDate+' => 'Establecer un campo con una fecha calculada a partir de otro campo con lógica adicional',
	'Class:cmdbAbstractObject/Method:SetComputedDate/Param:1' => 'Campo objetivo',
	'Class:cmdbAbstractObject/Method:SetComputedDate/Param:1+' => 'El campo a configurar, en el objeto actual',
	'Class:cmdbAbstractObject/Method:SetComputedDate/Param:2' => 'Modificador',
	'Class:cmdbAbstractObject/Method:SetComputedDate/Param:2+' => 'Información textual para modificar la fecha de origen, ej. "+3 días"',
	'Class:cmdbAbstractObject/Method:SetComputedDate/Param:3' => 'Campo Fuente',
	'Class:cmdbAbstractObject/Method:SetComputedDate/Param:3+' => 'El campo utilizado como fuente para aplicar la lógica del modificador',
	'Class:cmdbAbstractObject/Method:SetComputedDateIfNull' => 'Establecer fecha calculada si es nula',
	'Class:cmdbAbstractObject/Method:SetComputedDateIfNull+' => 'Establecer un campo no vacío con una fecha calculada a partir de otro campo con lógica adicional',
	'Class:cmdbAbstractObject/Method:SetComputedDateIfNull/Param:1' => 'Campo objetivo',
	'Class:cmdbAbstractObject/Method:SetComputedDateIfNull/Param:1+' => 'El campo a configurar, en el objeto actual',
	'Class:cmdbAbstractObject/Method:SetComputedDateIfNull/Param:2' => 'Modificador',
	'Class:cmdbAbstractObject/Method:SetComputedDateIfNull/Param:2+' => 'Información textual para modificar la fecha de origen, ej. "+3 días"',
	'Class:cmdbAbstractObject/Method:SetComputedDateIfNull/Param:3' => 'Campo Fuente',
	'Class:cmdbAbstractObject/Method:SetComputedDateIfNull/Param:3+' => 'El campo utilizado como fuente para aplicar la lógica del modificador',
	'Class:cmdbAbstractObject/Method:Reset' => 'Restablecer',
	'Class:cmdbAbstractObject/Method:Reset+' => 'Restablecer a valor por omisión',
	'Class:cmdbAbstractObject/Method:Reset/Param:1' => 'Campo Destino',
	'Class:cmdbAbstractObject/Method:Reset/Param:1+' => 'Campo a restablecer',
	'Class:cmdbAbstractObject/Method:Copy' => 'Copiar',
	'Class:cmdbAbstractObject/Method:Copy+' => 'Copier el valor de un campo a otro',
	'Class:cmdbAbstractObject/Method:Copy/Param:1' => 'Campo Destino',
	'Class:cmdbAbstractObject/Method:Copy/Param:1+' => 'Campo a asignar',
	'Class:cmdbAbstractObject/Method:Copy/Param:2' => 'Campo Origen',
	'Class:cmdbAbstractObject/Method:Copy/Param:2+' => 'Campo de donde se obtendrá valor',
	'Class:cmdbAbstractObject/Method:ApplyStimulus' => 'Aplicar Stimulus',
	'Class:cmdbAbstractObject/Method:ApplyStimulus+' => 'Aplicar stimulus específico a objeto actual',
	'Class:cmdbAbstractObject/Method:ApplyStimulus/Param:1' => 'Código Stimulus',
	'Class:cmdbAbstractObject/Method:ApplyStimulus/Param:1+' => 'Un código de stimulus válido para la clase actual',
	'Class:ResponseTicketTTO/Interface:iMetricComputer' => 'Tiempo a Pertenencia',
	'Class:ResponseTicketTTO/Interface:iMetricComputer+' => 'Objetivo basado en SLT de tipo TTO',
	'Class:ResponseTicketTTR/Interface:iMetricComputer' => 'Tiempo a Resolución',
	'Class:ResponseTicketTTR/Interface:iMetricComputer+' => 'Objetivo basado en SLT de tipo TTR',
));


//
// Class: Ticket
//

Dict::Add('ES CR', 'Spanish', 'Español, Castellano', array(
	'Class:Ticket/Attribute:team_email' => 'Team email~~',
	'Class:Ticket/Attribute:team_email+' => '~~',
));
