/*!
 * Cropper v0.7.9
 * https://github.com/fengyuanchen/cropper
 *
 * Copyright 2014-2015 Fengyuan Chen
 * Released under the MIT license
 */
(t=>{"function"==typeof define&&define.amd?define(["jquery"],t):"object"==typeof exports?t(require("jquery")):t(jQuery)})(function(g){function s(t,i){var e=[];return Y(i)&&e.push(i),e.slice.apply(t,e)}function i(t,i){var e=s(arguments,2);return function(){return t.apply(i,e.concat(s(arguments)))}}function r(t,i){this.element=t,this.$element=g(t),this.defaults=g.extend({},r.DEFAULTS,g.isPlainObject(i)?i:{}),this.$original=n,this.ready=$,this.built=$,this.cropped=$,this.rotated=$,this.disabled=$,this.replaced=$,this.init()}var e,h=g(window),a=g(document),d=window.location,y=!0,$=!1,n=null,o="undefined",l="directive",t=".cropper",E=/^(e|n|w|s|ne|nw|sw|se|all|crop|move|zoom)$/,_=/^(x|y|width|height)$/,P=/^(naturalWidth|naturalHeight|width|height|aspectRatio|ratio|rotate)$/,p="cropper-modal",D="cropper-hidden",c="cropper-invisible",m="cropper-crop",f="cropper-disabled",u="mousedown touchstart",w="mousemove touchmove",v="mouseup mouseleave touchend touchleave touchcancel",x="wheel mousewheel DOMMouseScroll",b="resize"+t,C="dblclick",W="build"+t,H="built"+t,k="dragstart"+t,L="dragmove"+t,R="dragend"+t,Y=function(t){return"number"==typeof t},z=Math.sqrt,X=Math.min,T=Math.max,M=Math.abs,O=Math.sin,U=Math.cos,I=parseFloat;r.prototype={constructor:r,support:{canvas:g.isFunction(g("<canvas>")[0].getContext)},init:function(){var e=this.defaults;g.each(e,function(t,i){switch(t){case"aspectRatio":e[t]=M(I(i))||NaN;break;case"autoCropArea":e[t]=M(I(i))||.8;break;case"minWidth":case"minHeight":e[t]=M(I(i))||0;break;case"maxWidth":case"maxHeight":e[t]=M(I(i))||1/0}}),this.image={rotate:0},this.load()},load:function(){var t,i,e=this,h=this.$element,a=this.element,s=this.image,r="";h.is("img")?i=h.prop("src"):h.is("canvas")&&this.support.canvas&&(i=a.toDataURL()),i&&(this.replaced&&(s.rotate=0),this.defaults.checkImageOrigin&&this.isCrossOriginURL(i)&&(r=" crossOrigin",h=i,a="timestamp="+(new Date).getTime(),i=h+(-1===h.indexOf("?")?"?":"&")+a),this.$clone=t=g("<img"+r+' src="'+i+'">'),t.one("load",function(){s.naturalWidth=this.naturalWidth||t.width(),s.naturalHeight=this.naturalHeight||t.height(),s.aspectRatio=s.naturalWidth/s.naturalHeight,e.url=i,e.ready=y,e.build()}),t.addClass(c).prependTo("body"))},isCrossOriginURL:function(t){t=t.match(/^(https?:)\/\/([^\:\/\?#]+):?(\d*)/i);return!t||t[1]===d.protocol&&t[2]===d.hostname&&t[3]===d.port?$:y},build:function(){var t,i=this.$element,e=this.defaults;this.ready&&(this.built&&this.unbuild(),i.one(W,e.build),t=g.Event(W),i.trigger(t),t.isDefaultPrevented()||(this.$cropper=t=g(r.TEMPLATE),i.addClass(D),this.$clone.removeClass(c).prependTo(t),this.rotated||(this.$original=this.$clone.clone(),this.$original.addClass(D).prependTo(this.$cropper),this.originalImage=g.extend({},this.image)),this.$container=i.parent(),this.$container.append(t),this.$canvas=t.find(".cropper-canvas"),this.$dragger=t.find(".cropper-dragger"),this.$viewer=t.find(".cropper-viewer"),e.autoCrop?this.cropped=y:this.$dragger.addClass(D),e.modal&&this.$canvas.addClass(p),e.dashed||this.$dragger.find(".cropper-dashed").addClass(D),e.movable||this.$dragger.find(".cropper-face").data(l,"move"),e.resizable||this.$dragger.find(".cropper-line, .cropper-point").addClass(D),this.addListeners(),this.initPreview(),this.built=y,e.dragCrop&&this.setDragMode("crop"),this.update(),this.replaced=$,i.one(H,e.built),i.trigger(H)))},unbuild:function(){this.built&&(this.built=$,this.removeListeners(),this.$preview.empty(),this.$preview=n,this.$dragger=n,this.$canvas=n,this.$container=n,this.$cropper.remove(),this.$cropper=n)},update:function(t){this.initContainer(),this.initCropper(),this.initImage(),this.initDragger(),t?(this.setData(t,y),this.setDragMode("crop")):this.setData(this.defaults.data)},resize:function(){clearTimeout(this.resizing),this.resizing=setTimeout(g.proxy(this.update,this,this.getData()),200)},preview:function(){var t=this.image,s=this.dragger,r=t.width,d=t.height,n=s.left-t.left,o=s.top-t.top;this.$viewer.find("img").css({width:r,height:d,marginLeft:-n,marginTop:-o}),this.$preview.each(function(){var t=g(this),i=t.data(),e=i.width/s.width,h=i.width,a=s.height*e;i.height<a&&(e=i.height/s.height,h=s.width*e,a=i.height),t.width(h).height(a).find("img").css({width:r*e,height:d*e,marginLeft:-n*e,marginTop:-o*e})})},addListeners:function(){var t=this.defaults;this.$element.on(k,t.dragstart).on(L,t.dragmove).on(R,t.dragend),this.$cropper.on(u,g.proxy(this.dragstart,this)).on(C,g.proxy(this.dblclick,this)),t.zoomable&&this.$cropper.on(x,g.proxy(this.wheel,this)),t.multiple?this.$cropper.on(w,g.proxy(this.dragmove,this)).on(v,g.proxy(this.dragend,this)):a.on(w,this._dragmove=i(this.dragmove,this)).on(v,this._dragend=i(this.dragend,this)),h.on(b,this._resize=i(this.resize,this))},removeListeners:function(){var t=this.defaults;this.$element.off(k,t.dragstart).off(L,t.dragmove).off(R,t.dragend),this.$cropper.off(u,this.dragstart).off(C,this.dblclick),t.zoomable&&this.$cropper.off(x,this.wheel),t.multiple?this.$cropper.off(w,this.dragmove).off(v,this.dragend):a.off(w,this._dragmove).off(v,this._dragend),h.off(b,this._resize)},initPreview:function(){var i=this.url;this.$preview=g(this.defaults.preview),this.$viewer.html('<img src="'+i+'">'),this.$preview.each(function(){var t=g(this);t.data({width:t.width(),height:t.height()}).html('<img src="'+i+'" style="display:block;width:100%;min-width:0!important;min-height:0!important;max-width:none!important;max-height:none!important;">')})},initContainer:function(){var t=this.$element,i=this.$container,e=this.$cropper,h=this.defaults;e.addClass(D),t.removeClass(D),this.container={width:T(i.width(),h.minContainerWidth),height:T(i.height(),h.minContainerHeight)},t.addClass(D),e.removeClass(D)},initCropper:function(){var t,i=this.container,e=this.image;0<=e.naturalWidth*i.height/e.naturalHeight-i.width?(t={width:i.width,height:i.width/e.aspectRatio,left:0}).top=(i.height-t.height)/2:(t={width:i.height*e.aspectRatio,height:i.height,top:0}).left=(i.width-t.width)/2,this.$cropper.css({width:t.width,height:t.height,left:t.left,top:t.top}),this.cropper=t},initImage:function(){var t=this.image,i=this.cropper,e={_width:i.width,_height:i.height,width:i.width,height:i.height,left:0,top:0,ratio:i.width/t.naturalWidth};this.defaultImage=g.extend({},t,e),t._width!==i.width||t._height!==i.height?g.extend(t,e):(t=g.extend({},e,t),this.replaced&&(t.ratio=e.ratio)),this.image=t,this.renderImage()},renderImage:function(t){var i=this.image;"zoom"===t&&(i.left-=(i.width-i.oldWidth)/2,i.top-=(i.height-i.oldHeight)/2),i.left=X(T(i.left,i._width-i.width),0),i.top=X(T(i.top,i._height-i.height),0),this.$clone.css({width:i.width,height:i.height,marginLeft:i.left,marginTop:i.top}),t&&(this.defaults.done(this.getData()),this.preview())},initDragger:function(){var t=this.defaults,i=this.cropper,e=t.aspectRatio||this.image.aspectRatio,h=this.image.ratio,a=0<=i.height*e-i.width?{height:i.width/e,width:i.width,left:0,top:(i.height-i.width/e)/2,maxWidth:i.width,maxHeight:i.width/e}:{height:i.height,width:i.height*e,left:(i.width-i.height*e)/2,top:0,maxWidth:i.height*e,maxHeight:i.height};a.minWidth=0,a.minHeight=0,t.aspectRatio?(isFinite(t.maxWidth)?(a.maxWidth=X(a.maxWidth,t.maxWidth*h),a.maxHeight=a.maxWidth/e):isFinite(t.maxHeight)&&(a.maxHeight=X(a.maxHeight,t.maxHeight*h),a.maxWidth=a.maxHeight*e),0<t.minWidth?(a.minWidth=T(0,t.minWidth*h),a.minHeight=a.minWidth/e):0<t.minHeight&&(a.minHeight=T(0,t.minHeight*h),a.minWidth=a.minHeight*e)):(a.maxWidth=X(a.maxWidth,t.maxWidth*h),a.maxHeight=X(a.maxHeight,t.maxHeight*h),a.minWidth=T(0,t.minWidth*h),a.minHeight=T(0,t.minHeight*h)),a.minWidth=X(a.maxWidth,a.minWidth),a.minHeight=X(a.maxHeight,a.minHeight),(e=g.extend({},a)).width=T(a.minWidth,a.width*t.autoCropArea),e.height=T(a.minHeight,a.height*t.autoCropArea),e.left=(i.width-e.width)/2,e.top=(i.height-e.height)/2,e.oldLeft=a.oldLeft=a.left,e.oldTop=a.oldTop=a.top,this.autoCropDragger=e,this.defaultDragger=g.extend({},a),this.dragger=a},renderDragger:function(){var t=this.dragger,i=this.cropper;t.width>t.maxWidth?(t.width=t.maxWidth,t.left=t.oldLeft):t.width<t.minWidth&&(t.width=t.minWidth,t.left=t.oldLeft),t.maxHeight<t.height?(t.height=t.maxHeight,t.top=t.oldTop):t.height<t.minHeight&&(t.height=t.minHeight,t.top=t.oldTop),t.left=X(T(t.left,0),i.width-t.width),t.top=X(T(t.top,0),i.height-t.height),t.oldLeft=t.left,t.oldTop=t.top,this.dragger=t,this.defaults.movable&&this.$dragger.find(".cropper-face").data(l,t.width===i.width&&t.height===i.height?"move":"all"),this.disabled||this.defaults.done(this.getData()),this.$dragger.css({width:t.width,height:t.height,left:t.left,top:t.top}),this.preview()},reset:function(t){this.cropped&&!this.disabled&&(t&&(this.defaults.data={}),this.image=g.extend({},this.defaultImage),this.renderImage(),this.dragger=g.extend({},this.defaultDragger),this.setData(this.defaults.data))},clear:function(){this.cropped&&!this.disabled&&(this.cropped=$,this.setData({x:0,y:0,width:0,height:0}),this.$canvas.removeClass(p),this.$dragger.addClass(D))},destroy:function(){var t=this.$element;this.ready||this.$clone.off("load").remove(),this.unbuild(),t.removeClass(D).removeData("cropper"),this.rotated&&t.attr("src",this.$original.attr("src"))},replace:function(t,i){var e,h=this,a=this.$element,s=this.element;!this.disabled&&t&&t!==this.url&&t!==a.attr("src")&&(i||(this.rotated=$,this.replaced=y),a.is("img")?(a.attr("src",t),this.load()):a.is("canvas")&&this.support.canvas&&(e=s.getContext("2d"),g('<img src="'+t+'">').one("load",function(){s.width=this.width,s.height=this.height,e.clearRect(0,0,s.width,s.height),e.drawImage(this,0,0),h.load()})))},setData:function(t,i){var e=this.cropper,h=this.dragger,a=this.image,s=this.defaults.aspectRatio;this.built&&!this.disabled&&typeof t!=o&&(t!==n&&!g.isEmptyObject(t)||(h=g.extend({},this.autoCropDragger)),g.isPlainObject(t)&&!g.isEmptyObject(t)&&(i||(this.defaults.data=t),t=this.transformData(t),Y(t.x)&&t.x<=e.width-a.left&&(h.left=t.x+a.left),Y(t.y)&&t.y<=e.height-a.top&&(h.top=t.y+a.top),s?Y(t.width)&&t.width<=h.maxWidth&&t.width>=h.minWidth?(h.width=t.width,h.height=h.width/s):Y(t.height)&&t.height<=h.maxHeight&&t.height>=h.minHeight&&(h.height=t.height,h.width=h.height*s):(Y(t.width)&&t.width<=h.maxWidth&&t.width>=h.minWidth&&(h.width=t.width),Y(t.height)&&t.height<=h.maxHeight&&t.height>=h.minHeight&&(h.height=t.height))),this.dragger=h,this.renderDragger())},getData:function(t){var i=this.dragger,e=this.image,h={};return this.built&&(h={x:i.left-e.left,y:i.top-e.top,width:i.width,height:i.height},h=this.transformData(h,y,t)),h},transformData:function(t,e,h){var a=this.image.ratio,s={};return g.each(t,function(t,i){i=I(i),_.test(t)&&!isNaN(i)&&(s[t]=e?h?Math.round(i/a):i/a:i*a)}),s},setAspectRatio:function(t){var i="auto"===t;this.disabled||(t=I(t),(i||!isNaN(t)&&0<t)&&(this.defaults.aspectRatio=i?NaN:t,this.built)&&(this.initDragger(),this.renderDragger(),this.setData(this.defaults.data)))},getImageData:function(){var e={};return this.ready&&g.each(this.image,function(t,i){P.test(t)&&(e[t]=i)}),e},getDataURL:function(t,i,e){var h,a=g("<canvas>")[0],s=this.getData(),r="";return g.isPlainObject(t)||(e=i,i=t,t={}),t=g.extend({width:s.width,height:s.height},t),this.cropped&&this.support.canvas&&(a.width=t.width,a.height=t.height,h=a.getContext("2d"),"image/jpeg"===i&&(h.fillStyle="#fff",h.fillRect(0,0,t.width,t.height)),h.drawImage(this.$clone[0],s.x,s.y,s.width,s.height,0,0,t.width,t.height),r=a.toDataURL(i,e)),r},setDragMode:function(t){var i=this.$canvas,e=this.defaults,h=$,a=$;if(this.built&&!this.disabled){switch(t){case"crop":e.dragCrop&&(h=y,i.data(l,t));break;case"move":a=y,i.data(l,t);break;default:i.removeData(l)}i.toggleClass(m,h).toggleClass("cropper-move",a)}},enable:function(){this.built&&(this.disabled=$,this.$cropper.removeClass(f))},disable:function(){this.built&&(this.disabled=y,this.$cropper.addClass(f))},rotate:function(t){var i=this.image;t=I(t)||0,this.built&&0!==t&&!this.disabled&&this.defaults.rotatable&&this.support.canvas&&(this.rotated=y,t=i.rotate=(i.rotate+t)%360,this.replace(this.getRotatedDataURL(t),!0))},getRotatedDataURL:function(t){var i=g("<canvas>")[0],e=i.getContext("2d"),h=this.originalImage,a=h.naturalWidth,h=h.naturalHeight,s=M(t)%180,s=(90<s?180-s:s)*Math.PI/180,r=a*U(s)+h*O(s),s=a*O(s)+h*U(s);return i.width=r,i.height=s,e.save(),e.translate(r/2,s/2),e.rotate(t*Math.PI/180),e.drawImage(this.$original[0],-a/2,-h/2,a,h),e.restore(),i.toDataURL()},zoom:function(t){var i,e,h=this.image;t=I(t),this.built&&t&&!this.disabled&&this.defaults.zoomable&&(i=h.width*(1+t),t=h.height*(1+t),10<(e=i/h._width)||(e<1&&(i=h._width,t=h._height),e<=1?this.setDragMode("crop"):this.setDragMode("move"),h.oldWidth=h.width,h.oldHeight=h.height,h.width=i,h.height=t,h.ratio=h.width/h.naturalWidth,this.renderImage("zoom")))},dblclick:function(){this.disabled||(this.$canvas.hasClass(m)?this.setDragMode("move"):this.setDragMode("crop"))},wheel:function(t){var i=t.originalEvent,e=1;this.disabled||(t.preventDefault(),i.deltaY?e=0<i.deltaY?1:-1:i.wheelDelta?e=-i.wheelDelta/120:i.detail&&(e=0<i.detail?1:-1),this.zoom(.1*e))},dragstart:function(t){var i,e,h=t.originalEvent.touches,a=t;if(!this.disabled){if(h){if(1<(e=h.length)){if(!this.defaults.zoomable||2!==e)return;a=h[1],this.startX2=a.pageX,this.startY2=a.pageY,i="zoom"}a=h[0]}i=i||g(a.target).data(l),E.test(i)&&(t.preventDefault(),e=g.Event(k),this.$element.trigger(e),e.isDefaultPrevented()||(this.directive=i,this.cropping=$,this.startX=a.pageX,this.startY=a.pageY,"crop"===i&&(this.cropping=y,this.$canvas.addClass(p))))}},dragmove:function(t){var i,e=t.originalEvent.touches,h=t;if(!this.disabled){if(e){if(1<(i=e.length)){if(!this.defaults.zoomable||2!==i)return;h=e[1],this.endX2=h.pageX,this.endY2=h.pageY}h=e[0]}this.directive&&(t.preventDefault(),i=g.Event(L),this.$element.trigger(i),i.isDefaultPrevented()||(this.endX=h.pageX,this.endY=h.pageY,this.dragging()))}},dragend:function(t){this.disabled||this.directive&&(t.preventDefault(),t=g.Event(R),this.$element.trigger(t),t.isDefaultPrevented()||(this.cropping&&(this.cropping=$,this.$canvas.toggleClass(p,this.cropped&&this.defaults.modal)),this.directive=""))},dragging:function(){var t,i,e,h,a,s,r=this.directive,d=this.image,n=this.cropper,o=n.width,g=n.height,l=this.dragger,p=l.width,c=l.height,m=l.left,f=l.top,u=m+p,w=f+c,v=y,x=this.defaults.aspectRatio,b={x:this.endX-this.startX,y:this.endY-this.startY};switch(x&&(b.X=b.y*x,b.Y=b.x/x),r){case"all":m+=b.x,f+=b.y;break;case"e":0<=b.x&&(o<=u||x&&(f<=0||g<=w))?v=$:(p+=b.x,x&&(c=p/x,f-=b.Y/2),p<0&&(r="w",p=0));break;case"n":b.y<=0&&(f<=0||x&&(m<=0||o<=u))?v=$:(c-=b.y,f+=b.y,x&&(p=c*x,m+=b.X/2),c<0&&(r="s",c=0));break;case"w":b.x<=0&&(m<=0||x&&(f<=0||g<=w))?v=$:(p-=b.x,m+=b.x,x&&(c=p/x,f+=b.Y/2),p<0&&(r="e",p=0));break;case"s":0<=b.y&&(g<=w||x&&(m<=0||o<=u))?v=$:(c+=b.y,x&&(p=c*x,m-=b.X/2),c<0&&(r="n",c=0));break;case"ne":if(x){if(b.y<=0&&(f<=0||o<=u)){v=$;break}f+=b.y,p=(c-=b.y)*x}else!(0<=b.x)||u<o?p+=b.x:b.y<=0&&f<=0&&(v=$),(!(b.y<=0)||0<f)&&(c-=b.y,f+=b.y);p<0&&c<0?(r="sw",p=c=0):p<0?(r="nw",p=0):c<0&&(r="se",c=0);break;case"nw":if(x){if(b.y<=0&&(f<=0||m<=0)){v=$;break}f+=b.y,p=(c-=b.y)*x,m+=b.X}else!(b.x<=0)||0<m?(p-=b.x,m+=b.x):b.y<=0&&f<=0&&(v=$),(!(b.y<=0)||0<f)&&(c-=b.y,f+=b.y);p<0&&c<0?(r="se",p=c=0):p<0?(r="ne",p=0):c<0&&(r="sw",c=0);break;case"sw":if(x){if(b.x<=0&&(m<=0||g<=w)){v=$;break}m+=b.x,c=(p-=b.x)/x}else!(b.x<=0)||0<m?(p-=b.x,m+=b.x):0<=b.y&&g<=w&&(v=$),(!(0<=b.y)||w<g)&&(c+=b.y);p<0&&c<0?(r="ne",p=c=0):p<0?(r="se",p=0):c<0&&(r="nw",c=0);break;case"se":if(x){if(0<=b.x&&(o<=u||g<=w)){v=$;break}c=(p+=b.x)/x}else!(0<=b.x)||u<o?p+=b.x:0<=b.y&&g<=w&&(v=$),(!(0<=b.y)||w<g)&&(c+=b.y);p<0&&c<0?(r="nw",p=c=0):p<0?(r="sw",p=0):c<0&&(r="ne",c=0);break;case"move":d.left+=b.x,d.top+=b.y,this.renderImage("move"),v=$;break;case"zoom":this.zoom((t=d.width,i=d.height,e=M(this.startX-this.startX2),h=M(this.startY-this.startY2),a=M(this.endX-this.endX2),s=M(this.endY-this.endY2),(z(a*a+s*s)-z(e*e+h*h))/z(t*t+i*i))),this.endX2=this.startX2,this.endY2=this.startY2,v=$;break;case"crop":b.x&&b.y&&(a=this.$cropper.offset(),m=this.startX-a.left,f=this.startY-a.top,p=l.minWidth,c=l.minHeight,0<b.x?0<b.y?r="se":(r="ne",f-=c):0<b.y?(r="sw",m-=p):(r="nw",m-=p,f-=c),this.cropped||(this.cropped=y,this.$dragger.removeClass(D)))}v&&(l.width=p,l.height=c,l.left=m,l.top=f,this.directive=r,this.renderDragger()),this.startX=this.endX,this.startY=this.endY}},r.TEMPLATE=(e="div,span,directive,data,point,cropper,class,line,dashed".split(","),'<0 6="5-container"><0 6="5-canvas"></0><0 6="5-dragger"><1 6="5-viewer"></1><1 6="5-8 8-h"></1><1 6="5-8 8-v"></1><1 6="5-face" 3-2="all"></1><1 6="5-7 7-e" 3-2="e"></1><1 6="5-7 7-n" 3-2="n"></1><1 6="5-7 7-w" 3-2="w"></1><1 6="5-7 7-s" 3-2="s"></1><1 6="5-4 4-e" 3-2="e"></1><1 6="5-4 4-n" 3-2="n"></1><1 6="5-4 4-w" 3-2="w"></1><1 6="5-4 4-s" 3-2="s"></1><1 6="5-4 4-ne" 3-2="ne"></1><1 6="5-4 4-nw" 3-2="nw"></1><1 6="5-4 4-sw" 3-2="sw"></1><1 6="5-4 4-se" 3-2="se"></1></0></0>'.replace(/\d+/g,function(t){return e[t]})),r.DEFAULTS={aspectRatio:"auto",autoCropArea:.8,data:{},done:g.noop,preview:"",multiple:$,autoCrop:y,dragCrop:y,dashed:y,modal:y,movable:y,resizable:y,zoomable:y,rotatable:y,checkImageOrigin:y,minWidth:0,minHeight:0,maxWidth:1/0,maxHeight:1/0,minContainerWidth:300,minContainerHeight:150,build:n,built:n,dragstart:n,dragmove:n,dragend:n},r.setDefaults=function(t){g.extend(r.DEFAULTS,t)},r.other=g.fn.cropper,g.fn.cropper=function(e){var h,a=s(arguments,1);return this.each(function(){var t=g(this),i=t.data("cropper");i||t.data("cropper",i=new r(this,e)),"string"==typeof e&&g.isFunction(t=i[e])&&(h=t.apply(i,a))}),typeof h!=o?h:this},g.fn.cropper.Constructor=r,g.fn.cropper.setDefaults=r.setDefaults,g.fn.cropper.noConflict=function(){return g.fn.cropper=r.other,this}});
//# sourceMappingURL=cropper.js.map