'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";$.Class("Base_InterestsConflictModal_JS",{},{/**
		 * Register modal events
		 * @param {jQuery} modalContainer
		 */registerEvents:function registerEvents(modalContainer){switch(modalContainer.data("mode")){case"users":this.registerUsersEvents(modalContainer);break;case"unlock":this.registerUnlockEvents(modalContainer);break;case"confirmation":this.registerConfirmationEvents(modalContainer);}},/**
		 * Register users events
		 * @param {jQuery} modalContainer
		 */registerUsersEvents:function registerUsersEvents(modalContainer){modalContainer.find(".js-ic-canceled-btn").click(function(e){var btn=$(e.currentTarget),tr=btn.closest("tr"),icon=tr.find(".js-change-icon");app.hideModalWindow(),app.showConfirmModal({title:app.vtranslate("JS_ENTER_A_REASON"),showDialog:!0,multiLineDialog:!0,confirmedCallback:function confirmedCallback(notice,value){AppConnector.request($.extend({module:app.getModuleName(),action:"InterestsConflict",mode:"usersCancel",id:tr.data("id"),comment:value},modalContainer.find(".js-modal-form").serializeFormData())).done(function(data){data.result&&(btn.hide(),icon.length&&icon.removeClass("fa-times text-danger").addClass("fa-slash text-dark"),app.showNotify({text:data.result.message,type:data.result.type}));});}});});},/**
		 * Register unlock events
		 * @param {jQuery} modalContainer
		 */registerUnlockEvents:function registerUnlockEvents(modalContainer){var form=modalContainer.find(".js-modal-form");modalContainer.find(".js-ic-send-btn").click(function(){form.validationEngine("validate")&&AppConnector.request($.extend({module:app.getModuleName(),action:"InterestsConflict",mode:"unlock"},form.serializeFormData())).done(function(data){data.result&&(app.showNotify({text:data.result.message,type:data.result.type}),"success"===data.result.type&&app.hideModalWindow());});});},/**
		 * Register confirmation events
		 * @param {jQuery} modalContainer
		 */registerConfirmationEvents:function registerConfirmationEvents(modalContainer){modalContainer.find(".js-ic-confirmation").click(function(e){var value=$(e.currentTarget).data("value");AppConnector.request($.extend({module:app.getModuleName(),action:"InterestsConflict",mode:"confirmation",value:value},modalContainer.find(".js-modal-form").serializeFormData())).done(function(data){data.result&&(app.showNotify({text:data.result.message,type:data.result.type}),app.hideModalWindow(),window.location.reload());});});}});
//# sourceMappingURL=InterestsConflictModal.min.js.map
