'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter(function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable})),t.push.apply(t,o);}return t}function _objectSpread(e){for(var t,r=1;r<arguments.length;r++)t=null==arguments[r]?{}:arguments[r],r%2?ownKeys(Object(t),!0).forEach(function(r){_defineProperty(e,r,t[r]);}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach(function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r));});return e}function _defineProperty(obj,key,value){return key=_toPropertyKey(key),key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}function _defineProperties(target,props){for(var descriptor,i=0;i<props.length;i++)descriptor=props[i],descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}function _createClass(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Object.defineProperty(Constructor,"prototype",{writable:!1}),Constructor}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return "symbol"==_typeof(i)?i:i+""}function _toPrimitive(t,r){if("object"!=_typeof(t)||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=_typeof(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return ("string"===r?String:Number)(t)}window.Settings_Picklist_Index_Js=/*#__PURE__*/function(){function _class(){_classCallCheck(this,_class);}return _createClass(_class,[{key:"getProgressIndicator",value:/**
	 * Get progress inducator element
	 * @param {jQuery} block
	 * @returns
	 */function getProgressIndicator(block){var params={position:"html",blockInfo:{enabled:!0}};return "undefined"!=typeof block&&(params.blockInfo.elementToBlock=block),$.progressIndicator(params)}/**
	 * Change module event
	 * @param {string} selectedModule
	 */},{key:"changeModule",value:function changeModule(selectedModule){var _this=this;if(!selectedModule)return void app.showNotify({type:"error",text:app.vtranslate("JS_PLEASE_SELECT_MODULE")});var progressIndicatorElement=this.getProgressIndicator();AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),source_module:selectedModule,view:"IndexAjax",mode:"getPickListDetailsForModule"}).done(function(data){_this.picklistContainer.html(data),_this.picklistField=_this.picklistContainer.find(".js-picklist-field"),progressIndicatorElement.progressIndicator({mode:"hide"}),App.Fields.Picklist.changeSelectElementView(_this.picklistContainer),_this.picklistField.trigger("change");});}/**
	 * Change picklist event
	 * @param {int} picklistId
	 * @returns
	 */},{key:"changePicklist",value:function changePicklist(picklistId){var _this2=this;if(!picklistId)return this.picklistDataContainer.html(""),!1;var progressIndicatorElement=this.getProgressIndicator();AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),source_module:this.moduleField.val(),view:"IndexAjax",mode:"getPickListValueForField",picklistName:picklistId}).done(function(data){_this2.picklistDataContainer.html(data),_this2.registerSortableEvent(),App.Fields.Picklist.showSelect2ElementView(_this2.picklistDataContainer.find(".select2")),progressIndicatorElement.progressIndicator({mode:"hide"});});}/**
	 * Change the order of picklist values
	 */},{key:"saveOrder",value:function saveOrder(){var seq={};this.picklistDataContainer.find(".js-picklist-value").each(function(i,element){seq[element.dataset.keyId]=i+1;}),this.saveAjax(_objectSpread({mode:"saveOrder",seq:seq},this.getDefaultParams()));}/**
	 * Get default params data
	 * @returns
	 */},{key:"getDefaultParams",value:function getDefaultParams(){return {module:app.getModuleName(),parent:app.getParentModuleName(),source_module:this.moduleField.val(),picklistName:this.picklistField.val()}}/**
	 * Register basic events
	 */},{key:"registerBasicEvents",value:function registerBasicEvents(){var _this3=this;this.moduleField.on("change",function(e){_this3.changeModule($(e.currentTarget).val());}),this.picklistContainer.on("change",".js-picklist-field",function(e){_this3.changePicklist($(e.currentTarget).val());}),this.picklistDataContainer.on("click",".js-picklist-edit",function(e){var fieldValueId=e.currentTarget.dataset.id;_this3.showEditView(_objectSpread({fieldValueId:fieldValueId,view:"Edit"},_this3.getDefaultParams()));}),this.picklistDataContainer.on("click",".js-picklist-create",function(){_this3.showEditView(_objectSpread({view:"Create"},_this3.getDefaultParams()));}),this.picklistDataContainer.on("click",".js-picklist-role",function(){_this3.showAssignRoleView(_objectSpread({view:"Create"},_this3.getDefaultParams()));}),this.picklistDataContainer.on("click",".js-picklist-order",function(){_this3.saveOrder();}),this.picklistDataContainer.on("click",".js-picklist-import",function(){_this3.importView();}),this.picklistDataContainer.on("click",".js-picklist-delete",function(e){_this3.deleteItem(e.currentTarget.dataset.id);}),this.picklistDataContainer.on("change",".js-role-list",function(e){_this3.loadRolePermissions($(e.currentTarget).val());}),this.picklistDataContainer.on("click","#assignedToRoleTab",function(){_this3.loadRolePermissions(_this3.picklistDataContainer.find(".js-role-list").val());}),this.regiserChangeRolePermissions(),this.registerSortableEvent(),this.registerEnablePickListValueClickEvent();}/**
	 * Edit item
	 * @param {Object} params
	 */},{key:"showEditView",value:function showEditView(params){var _this4=this;AppConnector.request(params).done(function(data){app.showModalWindow(data,function(container){App.Fields.Icon.register(container),container.find(".js-modal__save").on("click",function(e,skipConfirmation){var form=container.find("form");if(form.validationEngine("validate")){var confirmation=_this4.picklistField.find("option:selected").data("confirmation");if(!0!==skipConfirmation&&confirmation!==void 0)app.showConfirmModal({text:confirmation,confirmedCallback:function confirmedCallback(){$(e.currentTarget).trigger("click",!0);}});else {var progress=_this4.getProgressIndicator();_this4.preSaveValidation(form).done(function(valid){progress.progressIndicator({mode:"hide"}),!0===valid&&_this4.saveAjax(form.serializeFormData());});}}});});});}/**
	 * Assig role view
	 */},{key:"showAssignRoleView",value:function showAssignRoleView(){var _this5=this;AppConnector.request(_objectSpread({view:"AssignRoles"},this.getDefaultParams())).done(function(data){app.showModalWindow(data,function(container){container.find(".js-modal__save").on("click",function(){var form=container.find("form");form.validationEngine("validate")&&_this5.saveAjax(form.serializeFormData());});});});}/**
	 * Import view
	 */},{key:"importView",value:function importView(){var _this6=this;AppConnector.request(_objectSpread({view:"Import"},this.getDefaultParams())).done(function(modal){app.showModalWindow(modal,function(container){container.find(".js-modal__save").on("click",function(){var form=container.find("form");if(form.validationEngine("validate")){var formData=new FormData(form[0]);if("text/csv"!==formData.get("file").type)return app.showNotify({text:app.vtranslate("JS_INVALID_FILE_TYPE"),type:"error"}),!1;if(formData.get("file").size>CONFIG.maxUploadLimit)return app.showNotify({text:app.vtranslate("JS_UPLOADED_FILE_SIZE_EXCEEDS"),type:"error"}),!1;var progress=_this6.getProgressIndicator();AppConnector.request({url:"index.php",type:"POST",data:formData,processData:!1,contentType:!1}).done(function(response){progress.progressIndicator({mode:"hide"}),form.find(".js-summary").removeClass("d-none"),form.find(".js-all-number").val(response.result.all),form.find(".js-imported-number").val(response.result.success),form.find(".js-errors-number").val(response.result.errors),form.find(".js-errors").val(response.result.errorMessage),container.find(".js-modal__save").addClass("d-none"),_this6.picklistField.trigger("change");}).fail(function(error,title){progress.progressIndicator({mode:"hide"}),app.showNotify({titleTrusted:!1,textTrusted:!1,title:title,text:error,type:"error"});});}});});});}/**
	 * Delete item
	 * @param {int} fieldValueId
	 */},{key:"deleteItem",value:function deleteItem(fieldValueId){var _this7=this;AppConnector.request(_objectSpread({fieldValueId:fieldValueId,view:"Delete"},this.getDefaultParams())).done(function(modal){app.showModalWindow(modal,function(container){container.find(".js-modal__save").on("click",function(e,skipConfirmation){var form=container.find("form");if(form.validationEngine("validate")){var confirmation=_this7.picklistField.find("option:selected").data("confirmation");!0!==skipConfirmation&&confirmation!==void 0?app.showConfirmModal({text:confirmation,confirmedCallback:function confirmedCallback(){$(e.currentTarget).trigger("click",!0);}}):_this7.saveAjax(form.serializeFormData());}});});});}/**
	 * Save data
	 * @param {Object} formData
	 */},{key:"saveAjax",value:function saveAjax(formData){var _this8=this,progress=this.getProgressIndicator();app.saveAjax("",[],formData).done(function(response){response.result?(app.showNotify({text:app.vtranslate("JS_SAVE_NOTIFY_OK"),type:"success"}),_this8.picklistField.trigger("change")):app.showNotify({text:app.vtranslate("JS_ERROR"),type:"error"}),app.hideModalWindow(),progress.progressIndicator({mode:"hide"});});}/**
	 * Register sortable event
	 */},{key:"registerSortableEvent",value:function registerSortableEvent(){var _this9=this,tbody=$(".js-picklist-table tbody",this.container);tbody.sortable({helper:function helper(_e,ui){return ui.children().each(function(_index,element){element=$(element),element.width(element.width());}),ui},containment:tbody,revert:!0,update:function update(){$("#saveSequence",_this9.container).removeAttr("disabled");}});}/**
	 * Load picklist values for role
	 * @param {string} roleId
	 */},{key:"loadRolePermissions",value:function loadRolePermissions(roleId){var _this10=this,progressIndicatorElement=this.getProgressIndicator(this.container.find(".tab-content"));AppConnector.request(_objectSpread({view:"IndexAjax",mode:"getPickListValueByRole",rolesSelected:roleId},this.getDefaultParams())).done(function(data){_this10.container.find("#pickListValeByRoleContainer").html(data),progressIndicatorElement.progressIndicator({mode:"hide"});});}/**
	 * Register change role permission event
	 */},{key:"regiserChangeRolePermissions",value:function regiserChangeRolePermissions(){var _this11=this;this.picklistDataContainer.on("click",".js-role-order",function(e){var progressIndicatorElement=_this11.getProgressIndicator(_this11.container.find(".tab-content")),disabledValues=[],enabledValues=[];_this11.picklistDataContainer.find(".js-picklist-value-role").each(function(_i,element){element.classList.contains("selectedCell")?enabledValues.push(element.dataset.id):disabledValues.push(element.dataset.id);}),AppConnector.request(_objectSpread({action:"SaveAjax",mode:"enableOrDisable",rolesSelected:_this11.picklistDataContainer.find(".js-role-list").val(),enabled_values:enabledValues,disabled_values:disabledValues},_this11.getDefaultParams())).done(function(data){"undefined"!=typeof data.result&&(e.currentTarget.setAttribute("disabled","disabled"),progressIndicatorElement.progressIndicator({mode:"hide"}),app.showNotify({text:app.vtranslate("JS_LIST_UPDATED_SUCCESSFULLY"),type:"success"}));});});}/**
	 * Register click element event for role permissions
	 */},{key:"registerEnablePickListValueClickEvent",value:function registerEnablePickListValueClickEvent(){var _this12=this;this.picklistDataContainer.on("click",".js-picklist-value-role",function(e){if(e.currentTarget.classList.contains("selectedCell"))e.currentTarget.classList.remove("selectedCell"),e.currentTarget.children[0].remove();else {e.currentTarget.classList.add("selectedCell");var icon=document.createElement("i");icon.setAttribute("class","fas fa-check float-left"),e.currentTarget.prepend(icon);}_this12.picklistDataContainer.find(".js-role-order").removeAttr("disabled");});}/**
	 * PreSave validation
	 */},{key:"preSaveValidation",value:function preSaveValidation(form){var aDeferred=$.Deferred(),formData=new FormData(form.get(0));return formData.append("mode","preSaveValidation"),formData.get("name")?AppConnector.request({async:!1,url:"index.php",type:"POST",data:formData,processData:!1,contentType:!1}).done(function(data){var response=data.result;for(var i in response)!0!==response[i].result&&app.showNotify({text:response[i].message?response[i].message:app.vtranslate("JS_ERROR"),type:"error"});aDeferred.resolve(0>=data.result.length);}).fail(function(textStatus,errorThrown){app.showNotify({text:app.vtranslate("JS_ERROR"),type:"error"}),app.errorLog(textStatus,errorThrown),aDeferred.resolve(!1);}):aDeferred.resolve(!0),aDeferred.promise()}/**
	 * Register events
	 */},{key:"registerEvents",value:function registerEvents(){this.container=$(".js-container"),this.picklistContainer=$(".js-picklist-container"),this.picklistDataContainer=$(".js-picklist-data-container"),this.moduleField=this.container.find("#pickListModules"),this.picklistField=this.picklistContainer.find(".js-picklist-field"),this.registerBasicEvents();}}])}(),Vtiger_Base_Validator_Js("Vtiger_FieldLabel_Validator_Js",{/**
		 * Function which invokes field validation
		 * @param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var instance=new Vtiger_FieldLabel_Validator_Js;instance.setElement(field);var response=instance.validate();if(!0!==response)return instance.getError()}},{/**
		 * Function to validate the field label
		 * @return {boolean} if validation is successfull or error occurs
		 */validate:function validate(){var fieldValue=this.getFieldValue();return !/[\<\>\"\,\#]/.test(fieldValue)||(this.setError(app.vtranslate("JS_SPECIAL_CHARACTERS")+" < > \" , # "+app.vtranslate("JS_NOT_ALLOWED")),!1)}});
//# sourceMappingURL=Index.min.js.map
