'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/"use strict";$.Class("Settings_LayoutEditor_Js",{},{container:!1,updatedBlockSequence:{},inActiveFieldsList:!1,updatedBlockFieldsList:[],updatedBlocksList:[],blockNamesList:[],/**
		 * Function to set the inactive fields list used to show the inactive fields
		 */setInactiveFieldsList:function setInactiveFieldsList(){var thisInstance=this,contents=this.container.find(".contents"),json=contents.find(".inActiveFieldsArray");0<json.length&&(thisInstance.inActiveFieldsList=JSON.parse(json.val()));},/**
		 * Function to regiser the event to make the blocks sortable
		 */makeBlocksListSortable:function makeBlocksListSortable(){var thisInstance=this,contents=this.container.find(".contents"),table=contents.find(".blockSortable");contents.sortable({containment:contents,items:table,revert:!0,tolerance:"pointer",cursor:"move",update:function update(){thisInstance.updateBlockSequence();}});},/**
		 * Function which will update block sequence
		 */updateBlockSequence:function updateBlockSequence(){var thisInstance=this,progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}}),sequence=JSON.stringify(thisInstance.updateBlocksListByOrder()),params={};params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.action="Block",params.mode="updateSequenceNumber",params.sequence=sequence,AppConnector.request(params).done(function(){progressIndicatorElement.progressIndicator({mode:"hide"});var params={};params.text=app.vtranslate("JS_BLOCK_SEQUENCE_UPDATED"),Settings_Vtiger_Index_Js.showMessage(params);}).fail(function(){progressIndicatorElement.progressIndicator({mode:"hide"});});},/**
		 * Function which will arrange the sequence number of blocks
		 */updateBlocksListByOrder:function updateBlocksListByOrder(){var thisInstance=this,contents=this.container.find(".contents");return contents.find(".editFieldsTable.blockSortable").each(function(index,domElement){var blockTable=$(domElement),blockId=blockTable.data("blockId"),actualBlockSequence=blockTable.data("sequence"),expectedBlockSequence=index+1;expectedBlockSequence!=actualBlockSequence&&blockTable.data("sequence",expectedBlockSequence),thisInstance.updatedBlockSequence[blockId]=expectedBlockSequence;}),thisInstance.updatedBlockSequence},/**
		 * Function to register all the relatedList Events
		 */registerRelatedListEvents:function registerRelatedListEvents(){var thisInstance=this,relatedList=$("#relatedTabOrder");App.Fields.Picklist.showSelect2ElementView(relatedList.find(".relatedTabModulesList .js-related-column-list-container .select2_container"),{sortable:!0,sortableCb:function sortableCb(currentTarget){thisInstance.updateSelectedFields(currentTarget);}}),App.Fields.Picklist.showSelect2ElementView(relatedList.find(".relatedTabModulesList .js-related-custom-view-container .select2_container"),{sortable:!0,sortableCb:function sortableCb(currentTarget){thisInstance.updateCustomView(currentTarget);}}),relatedList.on("click",".inActiveRelationModule",function(e){var currentTarget=$(e.currentTarget),relatedModule=currentTarget.closest(".relatedModule");relatedModule.find(".activeRelationModule").removeClass("d-none").show(),currentTarget.hide(),thisInstance.changeStatusRelatedModule(relatedModule.data("relation-id"),!1);}),relatedList.on("click",".activeRelationModule",function(e){var currentTarget=$(e.currentTarget),relatedModule=currentTarget.closest(".relatedModule");relatedModule.find(".inActiveRelationModule").removeClass("d-none").show(),currentTarget.hide(),thisInstance.changeStatusRelatedModule(relatedModule.data("relation-id"),!0);}),relatedList.on("click",".removeRelation",function(e){var currentTarget=$(e.currentTarget),relatedModule=currentTarget.closest(".relatedModule");thisInstance.removeRelation(relatedModule);}),relatedList.on("click",".addToFavorites",function(e){var currentTarget=$(e.currentTarget);thisInstance.changeStateFavorites(currentTarget);}),relatedList.on("change",".relatedViewType",function(){var currentTarget=$(this),value=currentTarget.val();return value?void(currentTarget.validationEngine("hide"),thisInstance.changeRelatedViewType(currentTarget)):(currentTarget.validationEngine("showPrompt",app.vtranslate("JS_PLEASE_SELECT_ATLEAST_ONE_OPTION")),!1)}),relatedList.find(".js-related-column-list").on("change",function(e){thisInstance.updateSelectedFields($(e.currentTarget));}),relatedList.find(".js-related-custom-view").on("change",function(e){thisInstance.updateCustomView($(e.currentTarget));}),relatedList.find(".js-related-custom-view-orderby").on("change",function(e){thisInstance.updateCustomViewOrderBy($(e.currentTarget));}),relatedList.on("click",".addRelation",function(e){var currentTarget=$(e.currentTarget),container=currentTarget.closest("#relatedTabOrder"),contentsDiv=container.closest(".contentsDiv"),addRelationContainer=relatedList.find(".addRelationContainer").clone(!0,!0),callBackFunction=function(data){var labelElement=data.find(".relLabel");data.find("[name=\"multi_reference_field\"]").attr("disabled",!0),App.Fields.Picklist.showSelect2ElementView(data.find("select")),labelElement.val(data.find(".target option:selected").val()),data.on("change",".target",function(e){var currentTarget=$(e.currentTarget);switch($(this).val()){case"getMultiReference":data.find("[name=\"multi_reference_field\"]").attr("disabled",!1),data.find("[name=\"actions\"]").attr("disabled",!0),data.find("[name=\"target\"]").attr("readonly",!0);break;default:labelElement.val(currentTarget.find("option:selected").val());}}),data.find("[name=\"type\"]").on("change",function(){data.find(".actionsBlock").removeClass("d-none"),data.find(".targetBlock").removeClass("d-none");var label=data.find(".target option:selected").val();switch($(this).val()){case"getAttachments":data.find("[name=\"target\"] option").not("[value=\"Documents\"]").addClass("d-none"),data.find("[name=\"actions\"]").attr("disabled",!1),data.find("[name=\"target\"]").attr("readonly",!1),data.find("[name=\"multi_reference_field\"]").attr("disabled",!0);break;case"getMultiReference":data.find("[name=\"multi_reference_field\"]").attr("disabled",!1),data.find("[name=\"actions\"]").attr("disabled",!0),data.find("[name=\"target\"]").attr("readonly",!0),data.find(".actionsBlock").addClass("d-none"),data.find(".targetBlock").addClass("d-none"),label=data.find(".multiReferenceField option:selected").data("module");break;default:data.find("[name=\"multi_reference_field\"]").attr("disabled",!0),data.find("[name=\"actions\"]").attr("disabled",!1),data.find("[name=\"target\"]").attr("readonly",!1),data.find("[name=\"target\"] option").removeClass("d-none");}labelElement.val(label),App.Fields.Picklist.showSelect2ElementView(data.find("[name=\"target\"]"));}),data.on("click",".addButton",function(){if("getMultiReference"===data.find("[name=\"type\"]").val()&&null===data.find("[name=\"multi_reference_field\"]").val())data.find("[name=\"multi_reference_field\"]").validationEngine("showPrompt",app.vtranslate("JS_REQUIRED_FIELD"),"error","topRight",!0);else {var form=data.find("form").serializeFormData(),params={};params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.action="Relation",params.mode="addRelation",$.extend(params,form),AppConnector.request(params).done(function(data){var response=data.result;response&&response.success?thisInstance.getRelModuleLayoutEditor(container.find("[name=\"layoutEditorRelModules\"]").val()).done(function(data){contentsDiv.html(data),thisInstance.registerEvents();}):response&&response.message&&Settings_Vtiger_Index_Js.showMessage({type:"error",text:response.message});}),app.hideModalWindow();}});};app.showModalWindow(addRelationContainer,function(data){"function"==typeof callBackFunction&&callBackFunction(data);});});},getSelectedFields:function getSelectedFields(target){var selectedFields=[];return target.find(":selected").each(function(){selectedFields.push({id:$(this).val(),name:$(this).data("field-name")?$(this).data("field-name"):$(this).data("name")});}),selectedFields},/**
		 * Function to regiser the event to make the related modules sortable
		 */makeRelatedModuleSortable:function makeRelatedModuleSortable(){var thisInstance=this,relatedModulesContainer=$(".relatedModulesList"),modulesList=relatedModulesContainer.find(".relatedModule");relatedModulesContainer.sortable({containment:relatedModulesContainer,items:modulesList,handle:".mainBlockTableLabel",revert:!0,tolerance:"pointer",cursor:"move",update:function update(){thisInstance.updateSequenceRelatedModule();}});},changeRelatedViewType:function changeRelatedViewType(currentTarget){var relatedModule=currentTarget.closest(".relatedModule");AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),action:"Relation",mode:"updateRelatedViewType",relationId:relatedModule.data("relation-id"),types:currentTarget.val()}).done(function(data){data.success?Settings_Vtiger_Index_Js.showMessage({text:data.result.text}):Settings_Vtiger_Index_Js.showMessage({type:"error",text:data.error.message});}).fail(function(error){Settings_Vtiger_Index_Js.showMessage({textTrusted:!1,text:error.message});});},changeStateFavorites:function changeStateFavorites(currentTarget){var relatedModule=currentTarget.closest(".relatedModule"),status=1==currentTarget.data("state")?0:1,params={};params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.action="Relation",params.mode="updateStateFavorites",params.relationId=relatedModule.data("relation-id"),params.status=status,AppConnector.request(params).done(function(){currentTarget.data("state",status),currentTarget.find(".js-favorites-icon").toggleClass("d-none"),Settings_Vtiger_Index_Js.showMessage({text:app.vtranslate("JS_SAVE_NOTIFY_OK")});}).fail(function(error){var params={};params.text=error,Settings_Vtiger_Index_Js.showMessage(params);});},changeStatusRelatedModule:function changeStatusRelatedModule(relationId,status){var params={};params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.action="Relation",params.mode="changeStatusRelation",params.relationId=relationId,params.status=status,AppConnector.request(params).done(function(){var params={};params.text=status?app.vtranslate("JS_SAVED_CHANGE_STATUS_1"):app.vtranslate("JS_SAVED_CHANGE_STATUS_0"),Settings_Vtiger_Index_Js.showMessage(params);}).fail(function(error){var params={};params.text=error,params.type="error",Settings_Vtiger_Index_Js.showMessage(params);});},removeRelation:function removeRelation(relatedModule){var message=app.vtranslate("JS_DELETE_RELATION_CONFIRMATION");app.showConfirmModal({text:message,confirmedCallback:function confirmedCallback(){var params={};params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.action="Relation",params.mode="removeRelation",params.relationId=relatedModule.data("relation-id"),AppConnector.request(params).done(function(){relatedModule.remove(),Settings_Vtiger_Index_Js.showMessage({text:app.vtranslate("JS_REMOVE_RELATION_OK")});}).fail(function(){Settings_Vtiger_Index_Js.showMessage({text:message,type:"error"});});}});},updateSequenceRelatedModule:function updateSequenceRelatedModule(){var modules=[],relatedModulesContainer=$(".relatedModulesList"),params={},progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});relatedModulesContainer.find(".relatedModule").each(function(index,domElement){var relationId=$(domElement).data("relationId");modules.push({relationId:relationId,index:index});}),params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.action="Relation",params.mode="updateSequenceRelatedModule",params.modules=modules,AppConnector.request(params).done(function(){progressIndicatorElement.progressIndicator({mode:"hide"});var params={};params.text=app.vtranslate("JS_UPDATE_SEQUENCE"),Settings_Vtiger_Index_Js.showMessage(params);}).fail(function(error){progressIndicatorElement.progressIndicator({mode:"hide"});var params={};params.text=error,Settings_Vtiger_Index_Js.showMessage(params);});},updateSelectedFields:function updateSelectedFields(target){var selectedFields,thisInstance=this,params={},relatedModule=$(target).closest(".relatedModule"),progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});"inventory"==$(target).data("type")?(params.inventory=!0,selectedFields=$(target).val()):selectedFields=thisInstance.getSelectedFields($(target)),params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.action="Relation",params.mode="updateSelectedFields",params.relationId=relatedModule.data("relation-id"),params.fields=selectedFields,AppConnector.request(params).done(function(){progressIndicatorElement.progressIndicator({mode:"hide"});var params={};params.text=app.vtranslate("JS_UPDATED_FIELD_LIST_MODULE_RELATED"),Settings_Vtiger_Index_Js.showMessage(params);}).fail(function(error){progressIndicatorElement.progressIndicator({mode:"hide"});var params={};params.text=error,Settings_Vtiger_Index_Js.showMessage(params);});},updateCustomView:function updateCustomView(target){var params={},relatedModule=$(target).closest(".relatedModule"),progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.action="Relation",params.mode="updateCustomView",params.relationId=relatedModule.data("relation-id"),params.cv=target.val(),AppConnector.request(params).done(function(){progressIndicatorElement.progressIndicator({mode:"hide"});}).fail(function(){progressIndicatorElement.progressIndicator({mode:"hide"}),app.showNotify({text:app.vtranslate("JS_ERROR"),type:"error"});});},/**
		 * Set custom view order by
		 * (jQuery) target
		 */updateCustomViewOrderBy:function updateCustomViewOrderBy(target){var params={},relatedModule=$(target).closest(".relatedModule"),progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.action="Relation",params.mode="updateCustomViewOrderBy",params.relationId=relatedModule.data("relation-id"),params.orderby=target.prop("checked"),AppConnector.request(params).done(function(result){progressIndicatorElement.progressIndicator({mode:"hide"}),app.showNotify({text:result.result.message,type:"success"});}).fail(function(){progressIndicatorElement.progressIndicator({mode:"hide"}),app.showNotify({text:app.vtranslate("JS_ERROR"),type:"error",textTrusted:!1});});},/**
		 * Function to regiser the event to make the fields sortable
		 */makeFieldsListSortable:function makeFieldsListSortable(){var thisInstance=this,contents=this.container.find(".contents"),table=contents.find(".editFieldsTable");table.each(function(){var containment=$(this).closest(".moduleBlocks");$(this).find("ul[name=sortable1], ul[name=sortable2]").sortable({containment:containment,tolerance:"pointer",cursor:"move",connectWith:containment.find(".connectedSortable"),update:function update(e,ui){var currentField=ui.item;if(currentField.closest(".moduleBlocks").hasClass("inventoryBlock"))thisInstance.showSaveFieldSequenceButton(currentField.closest(".editFieldsTable"));else// rearrange the older block fields
if(thisInstance.showSaveFieldSequenceButton(thisInstance.getDetailViewLayout()),thisInstance.createUpdatedBlocksList(currentField),ui.sender){var olderBlock=ui.sender.closest(".editFieldsTable");thisInstance.reArrangeBlockFields(olderBlock);}}});});},getDetailViewLayout:function getDetailViewLayout(){return $("#detailViewLayout")},getInventoryViewLayout:function getInventoryViewLayout(){return $("#inventoryViewLayout")},/**
		 * Function to show the save button of fieldSequence
		 */showSaveFieldSequenceButton:function showSaveFieldSequenceButton(layout){var thisInstance=this,saveButton=layout.find(".saveFieldSequence");if(app.isHidden(saveButton)||app.isInvisible(saveButton)){saveButton.hasClass("inventorySequence")||(thisInstance.updatedBlocksList=[],thisInstance.updatedBlockFieldsList=[]),saveButton.removeClass("d-none"),saveButton.removeClass("invisible");var params={};params.text=app.vtranslate("JS_SAVE_THE_CHANGES_TO_UPDATE_FIELD_SEQUENCE"),params.type="info",Settings_Vtiger_Index_Js.showMessage(params);}},/**
		 * Function which will hide the saveFieldSequence button
		 */hideSaveFieldSequenceButton:function hideSaveFieldSequenceButton(){var layout=$("#detailViewLayout"),saveButton=layout.find(".saveFieldSequence");saveButton.addClass("d-none");},/**
		 * Function to create the blocks list which are updated while sorting
		 */createUpdatedBlocksList:function createUpdatedBlocksList(currentField){var thisInstance=this,block=currentField.closest(".editFieldsTable"),updatedBlockId=block.data("blockId");-1==$.inArray(updatedBlockId,thisInstance.updatedBlocksList)&&thisInstance.updatedBlocksList.push(updatedBlockId),thisInstance.reArrangeBlockFields(block);},/**
		 * Function that rearranges fields in the block when the fields are moved
		 * @param <jQuery object> block
		 */reArrangeBlockFields:function reArrangeBlockFields(block){// 1.get the containers, 2.compare the length, 3.if uneven then move the last element
var leftSideContainer=block.find("ul[name=sortable1]"),rightSideContainer=block.find("ul[name=sortable2]");if(leftSideContainer.children().length<rightSideContainer.children().length){var lastElementInRightContainer=rightSideContainer.children(":last");leftSideContainer.append(lastElementInRightContainer);}else if(leftSideContainer.children().length>rightSideContainer.children().length+1){//greater than 1
var lastElementInLeftContainer=leftSideContainer.children(":last");rightSideContainer.append(lastElementInLeftContainer);}},/**
		 * Function to create the list of updated blocks with all the fields and their sequences
		 */createUpdatedBlockFieldsList:function createUpdatedBlockFieldsList(){var thisInstance=this,contents=this.container.find(".contents");for(var index in thisInstance.updatedBlocksList){var updatedBlockId=thisInstance.updatedBlocksList[index],updatedBlock=contents.find(".block_"+updatedBlockId),firstBlockSortFields=updatedBlock.find("ul[name=sortable1]"),editFields=firstBlockSortFields.find(".editFields"),expectedFieldSequence=1;editFields.each(function(i,domElement){var fieldEle=$(domElement),fieldId=fieldEle.data("fieldId");thisInstance.updatedBlockFieldsList.push({fieldid:fieldId,sequence:expectedFieldSequence,block:updatedBlockId}),expectedFieldSequence+=2;});var secondBlockSortFields=updatedBlock.find("ul[name=sortable2]"),secondEditFields=secondBlockSortFields.find(".editFields"),sequenceValue=2;secondEditFields.each(function(i,domElement){var fieldEle=$(domElement),fieldId=fieldEle.data("fieldId");thisInstance.updatedBlockFieldsList.push({fieldid:fieldId,sequence:sequenceValue,block:updatedBlockId}),sequenceValue+=2;});}},/**
		 * Function to register click event for save button of fields sequence
		 */registerFieldSequenceSaveClick:function registerFieldSequenceSaveClick(){var _this=this;this.getDetailViewLayout().find(".saveFieldSequence").on("click",function(){_this.hideSaveFieldSequenceButton(),_this.createUpdatedBlockFieldsList(),_this.updateFieldSequence();});},/**
		 * Function will save the field sequences
		 */updateFieldSequence:function updateFieldSequence(){var progress=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),action:"Field",mode:"move",updatedFields:this.updatedBlockFieldsList}).done(function(){progress.progressIndicator({mode:"hide"}),window.location.reload(),Settings_Vtiger_Index_Js.showMessage({text:app.vtranslate("JS_FIELD_SEQUENCE_UPDATED")});}).fail(function(){progress.progressIndicator({mode:"hide"});});},/**
		 * Function to check if picklist exist
		 */checkPicklistExist:function checkPicklistExist(fieldNameValue){var aDeferred=$.Deferred();return AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),action:"Field",mode:"checkPicklistExist",fieldName:fieldNameValue.toLowerCase()}).done(function(data){data.result?app.showConfirmModal({text:app.vtranslate("JS_EXIST_PICKLIST_NAME"),confirmedCallback:function confirmedCallback(){aDeferred.resolve(!0);},rejectedCallback:function rejectedCallback(){aDeferred.resolve(!1);}}):aDeferred.resolve(!0);}),aDeferred.promise()},/**
		 * Function to register click event add system field button
		 */registerAddSystemFieldEvent:function registerAddSystemFieldEvent(){var _this2=this,contents=this.container.find(".contents");contents.find(".js-add-system-field").on("click",function(e){var blockId=$(e.currentTarget).closest(".editFieldsTable").data("blockId"),selectedModule=_this2.container.find("[name=\"layoutEditorModules\"]").val();app.showModalWindow(null,"index.php?module=LayoutEditor&parent=Settings&view=CreateSystemFields&sourceModule="+selectedModule,function(modalContainer){modalContainer.find(".js-modal__save").on("click",function(){var progress=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),action:"Field",mode:"createSystemField",sourceModule:selectedModule,blockId:blockId,field:modalContainer.find(".js-system-fields").val()}).done(function(){progress.progressIndicator({mode:"hide"}),window.location.reload();}).fail(function(){progress.progressIndicator({mode:"hide"});});});});});},/**
		 * Function to register click event add custom field button
		 */registerAddCustomFieldEvent:function registerAddCustomFieldEvent(){var _this3=this,thisInstance=this,contents=this.container.find(".contents");contents.find(".addCustomField").on("click",function(e){var blockId=$(e.currentTarget).closest(".editFieldsTable").data("blockId"),addFieldContainer=_this3.container.find(".createFieldModal").clone(!0,!0);addFieldContainer.removeClass("d-none").show();var callBackFunction=function(data){App.Fields.Picklist.showSelect2ElementView(data.find("select"),{width:"100%"});var form=data.find(".createCustomFieldForm");form.attr("id","createFieldForm"),App.Fields.Picklist.showSelect2ElementView(form.find("[name=\"pickListValues\"]"),{tags:!0,tokenSeparators:[","]}),_this3.registerFieldTypeChangeEvent(form),_this3.registerMultiReferenceFieldsChangeEvent(form),_this3.registerMultiReferenceFilterFieldChangeEvent(form);var params=app.getvalidationEngineOptions(!0);params.onValidationComplete=function(form,valid){if(valid){var saveButton=form.find(":submit"),fieldNameValue=$("[name=\"fieldName\"]",form).val(),fieldTypeValue=$("[name=\"fieldType\"]",form).val();saveButton.attr("disabled","disabled"),thisInstance.validateFieldsValue(form).done(function(response){if(!response)"Picklist"==fieldTypeValue||"MultiSelectCombo"==fieldTypeValue||"MultipicklistTags"==fieldTypeValue?thisInstance.checkPicklistExist(fieldNameValue).done(function(result){result?thisInstance.saveCustomField(blockId,form):saveButton.removeAttr("disabled");}):thisInstance.saveCustomField(blockId,form);else {for(var index in response){var field=form.find("[name=\"".concat(index,"\"]"));field.validationEngine("showPrompt",response[index],"error","bottomLeft",!0);}saveButton.removeAttr("disabled");}});}return !1},form.validationEngine(params);};app.showModalWindow(addFieldContainer,function(data){"function"==typeof callBackFunction&&callBackFunction(data);},{width:"1000px"});});},/**
		 * Function to validate fields value
		 */validateFieldsValue:function validateFieldsValue(form){var aDeferred=$.Deferred(),params=form.serializeFormData();return params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.action="Field",params.mode="validate",params.sourceModule=$("#selectedModuleName").val(),AppConnector.request(params).done(function(data){aDeferred.resolve(data.result);}).fail(function(error,err){app.errorLog(error,err),aDeferred.resolve(!0);}),aDeferred.promise()},/**
		 * Function to save field and show message
		 */saveCustomField:function saveCustomField(blockId,form){var saveButton=form.find(":submit");this.addCustomField(blockId,form).done(function(data){if(data.success){app.hideModalWindow();var params={};params.text=app.vtranslate("JS_CUSTOM_FIELD_ADDED"),Settings_Vtiger_Index_Js.showMessage(params),window.location.reload();}else app.showNotify({title:513==data.error.code?form.find(".fieldLabelForm").text():form.find(".fieldNameForm").text(),type:"error",text:data.error.message}),saveButton.removeAttr("disabled");});},/**
		 * Function to create the array of block names list
		 */setBlocksListArray:function setBlocksListArray(form){var thisInstance=this;thisInstance.blockNamesList=[];var blocksListSelect=form.find("[name=\"beforeBlockId\"]");blocksListSelect.find("option").each(function(index,ele){var option=$(ele),label=option.data("label");thisInstance.blockNamesList.push(label.toLowerCase());});},/**
		 * Function to save the custom field details
		 */addCustomField:function addCustomField(blockId,form){var modalHeader=form.closest("#"+Window.lastModalId).find(".modal-header h3"),aDeferred=$.Deferred();modalHeader.progressIndicator({smallLoadingImage:!0,imageContainerCss:{display:"inline","margin-left":"18%",position:"absolute"}});var params=form.serializeFormData();return params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.action="Field",params.mode="add",params.blockid=blockId,params.sourceModule=$("#selectedModuleName").val(),AppConnector.request(params).done(function(data){modalHeader.progressIndicator({mode:"hide"}),aDeferred.resolve(data);}).fail(function(err,error,errorObj){modalHeader.progressIndicator({mode:"hide"}),void 0!==errorObj.responseText&&app.showNotify({title:JSON.parse(errorObj.responseText).error.message,type:"error"}),aDeferred.reject(error);}),aDeferred.promise()},/**
		 * Function to register change event for fieldType while adding custom field
		 */registerFieldTypeChangeEvent:function registerFieldTypeChangeEvent(form){var thisInstance=this,lengthInput=form.find("[name=\"fieldLength\"]"),lengthValidator=[{name:"DecimalMaxLength"}],maxLengthValidator=[{name:"MaxLength"}],decimalValidator=[{name:"FloatingDigits"}];//special validators while adding new field
//By default add the max length validator
//register the change event for field types
lengthInput.data("validator",maxLengthValidator),form.find("[name=\"fieldType\"]").on("change",function(e){var currentTarget=$(e.currentTarget),lengthInput=form.find("[name=\"fieldLength\"]"),selectedOption=currentTarget.find("option:selected");//hide all the elements like length, decimal,picklist
if(form.find(".supportedType").addClass("d-none"),form.find(".js-field-type-list").removeClass("d-none"),selectedOption.data("lengthsupported")&&(form.find(".lengthsupported").removeClass("d-none"),selectedOption.data("nolimitforlength")?lengthInput.data("validator",[{name:"WholeNumberGreaterThanZero"}]):lengthInput.data("validator",maxLengthValidator)),selectedOption.data("decimalsupported")){var decimalFieldUi=form.find(".decimalsupported");decimalFieldUi.removeClass("d-none");var decimalInput=decimalFieldUi.find("[name=\"decimal\"]"),maxFloatingDigits=selectedOption.data("maxfloatingdigits");"undefined"!=typeof maxFloatingDigits&&(decimalInput.data("validator",decimalValidator),lengthInput.data("validator",lengthValidator)),selectedOption.data("decimalreadonly")?decimalInput.val(maxFloatingDigits).attr("readonly",!0):decimalInput.removeAttr("readonly").val("");}selectedOption.data("predefinedvalueexists")&&form.find(".preDefinedValueExists").removeClass("d-none"),selectedOption.data("picklistoption")&&form.find(".picklistOption").removeClass("d-none");var type=selectedOption.val();switch(type){case"Related1M":case"MultiReference":var moduleList=form.find(".preDefinedModuleList .referenceModule");form.find(".preDefinedModuleList").removeClass("d-none"),moduleList.select2("destroy"),"MultiReference"===type?moduleList.removeAttr("multiple"):moduleList.attr("multiple",""),App.Fields.Picklist.showSelect2ElementView(moduleList);break;case"Tree":case"CategoryMultipicklist":form.find(".preDefinedTreeList").removeClass("d-none");break;case"ServerAccess":form.find(".js-server-access-list").removeClass("d-none");break;case"MultiReferenceValue":form.find(".preMultiReferenceValue").removeClass("d-none"),thisInstance.loadMultiReferenceFields(form);break;case"MapCoordinates":form.find(".coordinateOption").removeClass("d-none");break;case"MultipicklistTags":var picklistTags=form.find(".preDefinedValueExists");picklistTags.find(".redColor").remove();var pickListValues=picklistTags.find("#pickListValues");pickListValues.attr("data-validation-engine",pickListValues.data("validation-engine").replace("required, ",""));break;case"Group":form.find(".js-group-module-option").removeClass("d-none");break;case"Virtual":form.find(".js-virtual-fields").removeClass("d-none"),form.find(".js-field-type-list").addClass("d-none");}});},/**
		 * Function to register click event for add custom block button
		 */registerAddCustomBlockEvent:function registerAddCustomBlockEvent(){var thisInstance=this,contents=this.container.find(".contents");contents.find(".addCustomBlock").on("click",function(e){var addBlockContainer=contents.find(".addBlockModal").clone(!0,!0),callBackFunction=function(data){data.find(".addBlockModal").removeClass("d-none").show(),App.Fields.Picklist.showSelect2ElementView(data.find("select"));var form=data.find(".addCustomBlockForm");thisInstance.setBlocksListArray(form);var fieldLabel=form.find("[name=\"label\"]"),params=Object.create(app.validationEngineOptions);params.onValidationComplete=function(form,valid){if(valid){var formData=form.serializeFormData();if(-1==$.inArray(formData.label.toLowerCase(),thisInstance.blockNamesList))return thisInstance.saveBlockDetails(form).done(function(data){if(data.success){var result=data.result;thisInstance.displayNewCustomBlock(result),thisInstance.updateNewSequenceForBlocks(result.sequenceList),thisInstance.appendNewBlockToBlocksList(result,form),thisInstance.makeFieldsListSortable();}}),app.hideModalWindow(),valid;var result=app.vtranslate("JS_BLOCK_NAME_EXISTS");return fieldLabel.validationEngine("showPrompt",result,"error","topLeft",!0),void e.preventDefault()}},form.validationEngine(params),form.on("submit",function(e){e.preventDefault();});};app.showModalWindow(addBlockContainer,function(data){callBackFunction(data);},{width:"1000px"});});},/**
		 * Function to save the new custom block details
		 */saveBlockDetails:function saveBlockDetails(form){var aDeferred=$.Deferred(),progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}}),params=form.serializeFormData();return params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.sourceModule=$("#selectedModuleName").val(),params.action="Block",params.mode="save",AppConnector.request(params).done(function(data){var response=data.result;progressIndicatorElement.progressIndicator({mode:"hide"}),response&&response.success?(app.showNotify({type:"success",text:app.vtranslate("JS_CUSTOM_BLOCK_ADDED")}),aDeferred.resolve(data)):(app.showNotify({type:"error",text:response.message}),aDeferred.reject(!1));}).fail(function(error){aDeferred.reject(error);}),aDeferred.promise()},/**
		 * Function used to display the new custom block ui after save
		 */displayNewCustomBlock:function displayNewCustomBlock(result){var contents=this.container.find(".contents"),beforeBlockId=result.beforeBlockId,beforeBlock=contents.find(".block_"+beforeBlockId),newBlockCloneCopy=contents.find(".newCustomBlockCopy").clone(!0,!0);newBlockCloneCopy.data("blockId",result.id).find(".blockLabel").append($("<strong class=\"align-middle\">"+result.label+"</strong>")),newBlockCloneCopy.find(".js-block-visibility").data("blockId",result.id),result.isAddCustomFieldEnabled&&newBlockCloneCopy.find(".addCustomField").removeClass("d-none"),beforeBlock.after(newBlockCloneCopy.removeClass("d-none newCustomBlockCopy").addClass("editFieldsTable block_"+result.id)),newBlockCloneCopy.find(".blockFieldsList").sortable({connectWith:".blockFieldsList"});},/**
		 * Function to update the sequence for all blocks after adding new Block
		 */updateNewSequenceForBlocks:function updateNewSequenceForBlocks(sequenceList){var contents=this.container.find(".contents");$.each(sequenceList,function(blockId,sequence){contents.find(".block_"+blockId).data("sequence",sequence);});},/**
		 * Function to update the block list with the new block label in the clone container
		 */appendNewBlockToBlocksList:function appendNewBlockToBlocksList(result){var contents=this.container.find(".contents"),hiddenAddBlockModel=contents.find(".addBlockModal"),blocksListSelect=hiddenAddBlockModel.find("[name=\"beforeBlockId\"]"),option=$("<option>",{value:result.id,text:result.label});blocksListSelect.append(option.attr("data-label",result.label));},/**
		 * Function to update the block list to remove the deleted custom block label in the clone container
		 */removeBlockFromBlocksList:function removeBlockFromBlocksList(blockId){var contents=this.container.find(".contents"),hiddenAddBlockModel=contents.find(".addBlockModal"),blocksListSelect=hiddenAddBlockModel.find("[name=\"beforeBlockId\"]");blocksListSelect.find("option[value=\""+blockId+"\"]").remove();},/**
		 * Function to register the change event for block visibility
		 */registerBlockVisibilityEvent:function registerBlockVisibilityEvent(){var thisInstance=this,contents=this.container.find(".contents");contents.on("click",".js-block-visibility",function(e){var currentTarget=$(e.currentTarget);thisInstance.updateBlockStatus(currentTarget);});},/**
		 * Function to save the changed visibility for the block
		 */updateBlockStatus:function updateBlockStatus(currentTarget){var blockStatus=currentTarget.data("visible"),progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}}),params={};params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.sourceModule=$("#selectedModuleName").val(),params.action="Block",params.mode="save",params.blockid=currentTarget.data("blockId"),params.display_status=blockStatus,AppConnector.request(params).done(function(){progressIndicatorElement.progressIndicator({mode:"hide"});var params={};params.text="1"==blockStatus?app.vtranslate("JS_BLOCK_VISIBILITY_SHOW"):"2"==blockStatus?app.vtranslate("JS_BLOCK_VISIBILITY_DYNAMIC"):app.vtranslate("JS_BLOCK_VISIBILITY_HIDE"),Settings_Vtiger_Index_Js.showMessage(params);}).fail(function(){progressIndicatorElement.progressIndicator({mode:"hide"});});},/**
		 * Function to register the click event for inactive fields list
		 */registerInactiveFieldsEvent:function registerInactiveFieldsEvent(){var thisInstance=this,contents=this.container.find(".contents");contents.on("click",".js-inactive-fields-btn",function(e){var currentTarget=$(e.currentTarget),currentBlock=currentTarget.closest(".editFieldsTable");//If there are no hidden fields, show pnotify
if($.isEmptyObject(thisInstance.inActiveFieldsList)){var params={};params.text=app.vtranslate("JS_NO_HIDDEN_FIELDS_EXISTS"),params.type="error",Settings_Vtiger_Index_Js.showMessage(params);}else {var inActiveFieldsContainer=contents.find(".inactiveFieldsModal").clone(!0,!0),callBackFunction=function(data){data.find(".inactiveFieldsModal").removeClass("d-none").show();var form=data.find(".inactiveFieldsForm");//register click event for reactivate button in the inactive fields modal
thisInstance.showHiddenFields(form),form.on("submit",function(e){thisInstance.createReactivateFieldslist(form),app.hideModalWindow(),e.preventDefault();});};app.showModalWindow(inActiveFieldsContainer,function(data){"function"==typeof callBackFunction&&callBackFunction(data);},{width:"1000px"});}});},/**
		 * Function to show the list of inactive fields in the modal
		 */showHiddenFields:function showHiddenFields(form){var self=this,detail=$("#detailViewLayout");$.each(self.inActiveFieldsList,function(blockId,fields){form.find(".inActiveList").append("<h5 class=\"\">"+detail.find(".js-block-container[data-block-id=\"".concat(blockId,"\"] .js-block-label")).text()+"</h5>"),$.each(fields,function(key,value){form.find(".inActiveList").append("<div class=\"checkbox\"><label><input type=\"checkbox\" class=\"inActiveField mr-2\" value=\"".concat(key,"\" data-block=\"").concat(blockId,"\"/>").concat(value,"</label></div>"));}),form.find(".inActiveList").append("<hr>");});},/**
		 * Function to create the list of reactivate fields list
		 */createReactivateFieldslist:function createReactivateFieldslist(form){var self=this,blocks=[];form.find(".inActiveField").each(function(index,domElement){var element=$(domElement),fieldId=element.val(),blockId=element.data("block");element.is(":checked")&&(delete self.inActiveFieldsList[blockId][fieldId],!self.inActiveFieldsList[blockId]&&delete self.inActiveFieldsList[blockId],!blocks[blockId]&&(blocks[blockId]=[]),blocks[blockId].push(fieldId));}),$.each(blocks,function(blockId,fields){fields&&self.reActivateHiddenFields(blockId,fields);});},/**
		 * Function to unHide the selected fields in the inactive fields modal
		 */reActivateHiddenFields:function reActivateHiddenFields(blockId,fields){var progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}}),params={module:app.getModuleName(),parent:app.getParentModuleName(),action:"Field",mode:"unHide",blockId:blockId,fieldIdList:JSON.stringify(fields)},messageParams={};"[]"===params.fieldIdList?(messageParams.text=app.vtranslate("JS_NO_ITEM_SELECTED"),messageParams.type="error",progressIndicatorElement.progressIndicator({mode:"hide"}),Settings_Vtiger_Index_Js.showMessage(messageParams)):AppConnector.request(params).done(function(){progressIndicatorElement.progressIndicator({mode:"hide"}),window.location.reload();}).fail(function(){progressIndicatorElement.progressIndicator({mode:"hide"});});},/**
		 * Function to register the click event for delete custom block
		 */registerDeleteCustomBlockEvent:function registerDeleteCustomBlockEvent(){var thisInstance=this,contents=this.container.find(".contents");contents.on("click",".js-delete-custom-block-btn",function(e){var currentTarget=$(e.currentTarget),table=currentTarget.closest("div.editFieldsTable");app.showConfirmModal({text:app.vtranslate("JS_LBL_ARE_YOU_SURE_YOU_WANT_TO_DELETE"),confirmedCallback:function confirmedCallback(){thisInstance.deleteCustomBlock(table.data("blockId"));}});});},/**
		 * Function to delete the custom block
		 */deleteCustomBlock:function deleteCustomBlock(blockId){var thisInstance=this,progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}}),params={};params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.action="Block",params.mode="delete",params.blockid=blockId,AppConnector.request(params).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"});var params={},result=data.result;data.success&&result.success?(thisInstance.removeDeletedBlock(blockId),thisInstance.removeBlockFromBlocksList(blockId),params.text=app.vtranslate("JS_CUSTOM_BLOCK_DELETED")):result&&result.message&&(params.text=result.message,params.type="error"),Settings_Vtiger_Index_Js.showMessage(params);}).fail(function(error,err){progressIndicatorElement.progressIndicator({mode:"hide"}),app.errorLog(error,err);});},/**
		 * Function to remove the deleted custom block from the ui
		 */removeDeletedBlock:function removeDeletedBlock(blockId){var contents=this.container.find(".contents"),deletedTable=contents.find(".block_"+blockId);deletedTable.fadeOut("slow").remove();},/**
		 * Function to register the click event for delete custom field
		 */registerDeleteCustomFieldEvent:function registerDeleteCustomFieldEvent(contents){var thisInstance=this;"undefined"==typeof contents&&(contents=this.container.find(".contents")),contents.find(".deleteCustomField").on("click",function(e){var currentTarget=$(e.currentTarget);app.showConfirmModal({text:app.vtranslate("JS_LBL_ARE_YOU_SURE_YOU_WANT_TO_DELETE"),confirmedCallback:function confirmedCallback(){thisInstance.deleteCustomField(currentTarget.data("fieldId")).done(function(data){var response=data.result;if(response&&response.success){var field=currentTarget.closest("div.editFields"),blockId=field.data("blockId");field.parent().fadeOut("slow").remove(),thisInstance.reArrangeBlockFields($("#block_"+blockId)),Settings_Vtiger_Index_Js.showMessage({text:app.vtranslate("JS_CUSTOM_FIELD_DELETED")});}else Settings_Vtiger_Index_Js.showMessage({type:"error",text:response.message});});}});});},/**
		 * Function to delete the custom field
		 */deleteCustomField:function deleteCustomField(fieldId){var aDeferred=$.Deferred(),progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}}),params={};return params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.action="Field",params.mode="delete",params.fieldid=fieldId,AppConnector.request(params).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.resolve(data);}).fail(function(){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.reject();}),aDeferred.promise()},/**
		 * Function to register the cahnge event for mandatory & default checkboxes in edit field details
		 */registerFieldDetailsChange:function registerFieldDetailsChange(contents){contents.find("[name=\"mandatory\"]").on("change",function(e){var currentTarget=$(e.currentTarget);if("readonly"!==currentTarget.attr("readonly")){var form=currentTarget.closest(".fieldDetailsForm"),quickcreateEle=form.find("[name=\"quickcreate\"]").filter(":checkbox").not(".optionDisabled"),presenceEle=form.find("[name=\"presence\"]").filter(":checkbox").not(".optionDisabled");currentTarget.is(":checked")?(quickcreateEle.attr("checked",!0).attr("readonly","readonly"),presenceEle.attr("checked",!0).attr("readonly","readonly")):(quickcreateEle.removeAttr("readonly"),presenceEle.removeAttr("readonly"));}}),contents.find("[name=\"defaultvalue\"],[name=\"header_field\"]").on("change",function(e){var currentTarget=$(e.currentTarget),defaultValueUi=currentTarget.closest(".checkbox").find(".js-toggle-hide");currentTarget.is(":checked")?defaultValueUi.removeClass("zeroOpacity"):defaultValueUi.addClass("zeroOpacity");}),contents.find(".js-header_type").on("change",function(e){var el=$(e.currentTarget),relFieldsElement=el.closest(".js-toggle-hide").find(".js-header_rel_fields");"value"===el.val()?relFieldsElement.removeClass("d-none"):relFieldsElement.addClass("d-none");});},/**
		 * Function to register the click event for related modules list tab
		 */relatedModulesTabClickEvent:function relatedModulesTabClickEvent(){var thisInstance=this,contents=this.container.find(".contents"),relatedContainer=contents.find("#relatedTabOrder"),relatedTab=contents.find(".relatedListTab");relatedTab.on("click",function(){0<relatedContainer.find(".relatedTabModulesList").length||thisInstance.showRelatedTabModulesList(relatedContainer);});},/**
		 * Function to show the related tab modules list in the tab
		 */showRelatedTabModulesList:function showRelatedTabModulesList(relatedContainer){var thisInstance=this,params={};params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.sourceModule=$("#selectedModuleName").val(),params.view="Index",params.mode="showRelatedListLayout",AppConnector.request(params).done(function(data){relatedContainer.html(data),0<$(data).find(".relatedListContainer").length&&(thisInstance.makeRelatedModuleSortable(),thisInstance.registerRelatedListEvents());}).fail(function(){});},/**
		 * Function to get the respective module layout editor through pjax
		 */getModuleLayoutEditor:function getModuleLayoutEditor(selectedModule){var aDeferred=$.Deferred(),progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}}),params={};return params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.view="Index",params.sourceModule=selectedModule,AppConnector.requestPjax(params).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.resolve(data);}).fail(function(){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.reject();}),aDeferred.promise()},getRelModuleLayoutEditor:function getRelModuleLayoutEditor(selectedModule){var aDeferred=$.Deferred(),progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}}),params={};return params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.view="Index",params.mode="showRelatedListLayout",params.sourceModule=selectedModule,AppConnector.requestPjax(params).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.resolve(data);}).fail(function(){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.reject();}),aDeferred.promise()},/**
		 * Function to register the change event for layout editor modules list
		 */registerModulesChangeEvent:function registerModulesChangeEvent(){var thisInstance=this,container=this.container,contentsDiv=container.closest(".contentsDiv");App.Fields.Picklist.showSelect2ElementView(container.find("[name=\"layoutEditorModules\"]")),container.on("change","[name=\"layoutEditorModules\"]",function(e){var currentTarget=$(e.currentTarget),selectedModule=currentTarget.val();thisInstance.getModuleLayoutEditor(selectedModule).done(function(data){contentsDiv.html(data),thisInstance.registerEvents();});});},registerRelModulesChangeEvent:function registerRelModulesChangeEvent(){var thisInstance=this,container=this.container,contentsDiv=container.closest(".contentsDiv");App.Fields.Picklist.showSelect2ElementView(container.find("[name=\"layoutEditorRelModules\"]")),container.on("change","[name=\"layoutEditorRelModules\"]",function(e){var currentTarget=$(e.currentTarget),selectedModule=currentTarget.val();thisInstance.getRelModuleLayoutEditor(selectedModule).done(function(data){contentsDiv.html(data),thisInstance.registerEvents();});});},lockCheckbox:function lockCheckbox(contents){contents.on("change",":checkbox",function(e){var currentTarget=$(e.currentTarget);if("readonly"===currentTarget.attr("readonly")){var status=$(e.currentTarget).is(":checked");status?$(e.currentTarget).prop("checked",!1):$(e.currentTarget).prop("checked",!0),e.preventDefault();}});},registerEditFieldDetailsClick:function registerEditFieldDetailsClick(contents){var thisInstance=this;"undefined"==typeof contents&&(contents=this.container.find(".contents")),contents.find(".js-disable-field").on("click",function(e){var currentTarget=$(e.currentTarget);app.showConfirmModal({text:app.vtranslate("JS_ARE_YOU_SURE_YOU_WANT_TO_INACTIVE_FIELD"),confirmedCallback:function confirmedCallback(){var fieldRow=currentTarget.closest("div.editFields"),fieldId=fieldRow.data("fieldId"),block=fieldRow.closest(".editFieldsTable"),blockId=block.data("blockId");AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),action:"Field",mode:"save",fieldid:fieldId,presence:1}).done(function(response){fieldRow.parent().fadeOut("slow").remove(),$.isEmptyObject(thisInstance.inActiveFieldsList[blockId])?(0===thisInstance.inActiveFieldsList.length&&(thisInstance.inActiveFieldsList={}),thisInstance.inActiveFieldsList[blockId]={},thisInstance.inActiveFieldsList[blockId][fieldId]=response.result.label):thisInstance.inActiveFieldsList[blockId][fieldId]=response.result.label,thisInstance.reArrangeBlockFields(block),app.showNotify({type:"success",text:app.vtranslate("JS_SAVE_CHANGES")});});}});}),contents.find(".editFieldDetails").on("click",function(e){var currentTarget=$(e.currentTarget),fieldRow=currentTarget.closest("div.editFields"),fieldId=fieldRow.data("fieldId"),block=fieldRow.closest(".editFieldsTable"),blockId=block.data("blockId");app.showModalWindow({url:"index.php?parent=Settings&module=LayoutEditor&view=EditField&fieldId="+fieldRow.data("fieldId"),cb:function cb(modalContainer){thisInstance.registerFieldDetailsChange(modalContainer),thisInstance.lockCheckbox(modalContainer),thisInstance.registerVariableToParsers(modalContainer),app.registerEventForClockPicker(modalContainer.find(".clockPicker")),modalContainer.find("[data-inputmask]").inputmask(),modalContainer.find(".js-string-max-length").on("change",function(){app.showConfirmModal({text:app.vtranslate("JS_COLUMN_LENGTH_CHANGE_WARNING"),rejectedCallback:function rejectedCallback(){app.hideModalWindow();}});});},sendByAjaxCb:function sendByAjaxCb(_formData,response){if(response.success){Settings_Vtiger_Index_Js.showMessage({text:app.vtranslate("JS_FIELD_DETAILS_SAVED")});var result=response.result,fieldLabel=fieldRow.find(".fieldLabel");"1"===result.presence&&(fieldRow.parent().fadeOut("slow").remove(),$.isEmptyObject(thisInstance.inActiveFieldsList[blockId])?(0===thisInstance.inActiveFieldsList.length&&(thisInstance.inActiveFieldsList={}),thisInstance.inActiveFieldsList[blockId]={},thisInstance.inActiveFieldsList[blockId][fieldId]=result.label):thisInstance.inActiveFieldsList[blockId][fieldId]=result.label,thisInstance.reArrangeBlockFields(block)),result.mandatory?fieldLabel.find(".redColor").removeClass("d-none"):fieldLabel.find(".redColor").addClass("d-none");}}});});},registerVariableToParsers:function registerVariableToParsers(container){container.find(".configButton").on("click",function(){container.find(".js-toggle-hide .js-base-element").each(function(n,e){var currentElement=$(e);currentElement.hasClass("d-none")?currentElement.find("input,select").prop("disabled",!1):currentElement.find("input,select").prop("disabled",!0),currentElement.toggleClass("d-none");});}),container.find(".varibleToParsers").on("click",function(e){var element=$(e.currentTarget),container=element.closest(".js-base-element"),input=container.find("[name=\""+container.data("name")+"\"]"),fieldId=element.closest("form").find("[name=\"fieldid\"]").val(),id="varibleToParsersModal";app.showModalWindow({id:id,url:"index.php?parent=Settings&module=LayoutEditor&view=VaribleToParsers&fieldId="+fieldId+"&defaultValue="+input.val(),cb:function cb(modalContainer){modalContainer.find("[name=\"saveButton\"]").on("click",function(){input.val(modalContainer.find("select").val()),app.hideModalWindow(null,id);});}});}),App.Fields.Tree.register(container);},/**
		 * Function to register all the events for blocks
		 */registerBlockEvents:function registerBlockEvents(){var thisInstance=this;thisInstance.makeBlocksListSortable(),thisInstance.registerAddCustomFieldEvent(),thisInstance.registerAddSystemFieldEvent(),thisInstance.registerBlockVisibilityEvent(),thisInstance.registerInactiveFieldsEvent(),thisInstance.registerDeleteCustomBlockEvent();},/**
		 * Function to register all the events for fields
		 */registerFieldEvents:function registerFieldEvents(contents){var thisInstance=this;"undefined"==typeof contents&&(contents=this.container.find(".contents")),App.Fields.Date.register(contents),App.Fields.Picklist.changeSelectElementView(contents),thisInstance.makeFieldsListSortable(),thisInstance.registerDeleteCustomFieldEvent(contents),thisInstance.registerEditFieldDetailsClick(contents),contents.find(":checkbox").on("change",function(e){var currentTarget=$(e.currentTarget);if("readonly"==currentTarget.attr("readonly")){var status=$(e.currentTarget).is(":checked");status?$(e.currentTarget).prop("checked",!1):$(e.currentTarget).prop("checked",!0),e.preventDefault();}});},/**
		 * Function to register switch module type
		 */registerSwitch:function registerSwitch(){var _this4=this;this.container.find(".js-switch--inventory").on("click",function(event){event.preventDefault(),app.showConfirmModal({title:app.vtranslate("JS_EXTENDED_MODULE"),confirmedCallback:function confirmedCallback(){var progress=$.progressIndicator({message:app.vtranslate("JS_SAVE_LOADER_INFO"),position:"html",blockInfo:{enabled:!0}}),params={};params.sourceModule=_this4.container.find("[name=\"layoutEditorModules\"]").val(),params.type=event.currentTarget.dataset.value,app.saveAjax("changeModuleType",null,params).done(function(data){data.result&&(data.result.success?(_this4.container.find(".js-switch--inventory").prop("disabled",!0),Settings_Vtiger_Index_Js.showMessage({type:"success",text:data.result.message}),progress.progressIndicator({mode:"hide"})):window.location.reload());});}});});},/**
		 * Function to adding inventory field
		 */registerAddInventoryField:function registerAddInventoryField(){var _this5=this,thisInstance=this,container=thisInstance.getInventoryViewLayout();container.find(".addInventoryField").on("click",function(e){var currentTarget=$(e.currentTarget),selectedModule=_this5.container.find("[name=\"layoutEditorModules\"]").val(),blockId=currentTarget.closest(".inventoryBlock").data("block-id"),progress=$.progressIndicator();app.showModalWindow(null,"index.php?module=LayoutEditor&parent=Settings&view=CreateInventoryFields&mode=step1&sourceModule="+selectedModule+"&block="+blockId,function(modalContainer){app.showScrollBar(modalContainer.find(".well"),{height:"300px"}),thisInstance.registerStep1(modalContainer,blockId),progress.progressIndicator({mode:"hide"});});});},/**
		 * Function to editing inventory field
		 */registerEditInventoryField:function registerEditInventoryField(){var thisInstance=this,container=thisInstance.getInventoryViewLayout();container.find(".editInventoryField").on("click",function(e){var currentTarget=$(e.currentTarget),selectedModule=$("#layoutEditorContainer").find("[name=\"layoutEditorModules\"]").val(),editField=currentTarget.closest(".editFields"),progress=$.progressIndicator();app.showModalWindow(null,"index.php?module=LayoutEditor&parent=Settings&view=CreateInventoryFields&mode=step2&sourceModule="+selectedModule+"&type="+editField.data("type")+"&fieldName="+editField.data("name"),function(container){app.showPopoverElementView(container.find(".js-help-info")),thisInstance.registerStep2(container),progress.progressIndicator({mode:"hide"});});});},/**
		 * Function to adding inventory field first step
		 *
		 * @param {jQuery} container
		 * @param {int} blockId
		 */registerStep1:function registerStep1(container){var _this6=this,thisInstance=this;container.find(".js-next-button").on("click",function(){var selectedModule=_this6.container.find("[name=\"layoutEditorModules\"]").val(),type=container.find("select.type").val();null===type?container.find("select.type").validationEngine("showPrompt",app.vtranslate("JS_REQUIRED_FIELD"),"error","topRight",!0):app.hideModalWindow(function(){var progress=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});app.showModalWindow(null,"index.php?module=LayoutEditor&parent=Settings&view=CreateInventoryFields&mode=step2&sourceModule="+selectedModule+"&type="+type,function(modalContainer){thisInstance.registerStep2(modalContainer),progress.progressIndicator({mode:"hide"});});});});},/**
		 * Function to save inventory field
		 * @param {jQuery} container
		 */registerStep2:function registerStep2(container){var _this7=this,form=container.find("form");form.validationEngine(app.validationEngineOptions),form.on("submit",function(e){e.preventDefault();var formData=form.serializeFormData();form.validationEngine("validate")&&app.saveAjax("saveInventoryField",null,formData).done(function(data){if(app.hideModalWindow(),data.result&&data.success){var selectedModule=_this7.container.find("[name=\"layoutEditorModules\"]").val();window.location.href="index.php?module=LayoutEditor&parent=Settings&view=Index&tab=inventoryViewLayout&sourceModule="+selectedModule;}else app.showNotify({text:app.vtranslate("JS_ERROR"),type:"error"});});});},/**
		 * Function to register click event for save button of fields sequence
		 */registerInventoryFieldSequenceSaveClick:function registerInventoryFieldSequenceSaveClick(){var thisInstance=this,containerInventory=thisInstance.getInventoryViewLayout(),selectedModule=this.container.find("[name=\"layoutEditorModules\"]").val();containerInventory.on("click",".saveFieldSequence",function(e){var button=$(e.currentTarget),target=button.closest(".inventoryBlock"),fieldId=[];target.find(".editFields").each(function(){fieldId.push($(this).data("id"));}),app.saveAjax("saveSequence",null,{sourceModule:selectedModule,ids:fieldId}).done(function(){button.addClass("invisible");});});},/**
		 * removing elements in advanced blocks
		 */registerDeleteInventoryField:function registerDeleteInventoryField(){var thisInstance=this,container=thisInstance.getInventoryViewLayout(),selectedModule=this.container.find("[name=\"layoutEditorModules\"]").val();container.find(".deleteInventoryField").on("click",function(e){var currentTarget=$(e.currentTarget),liElement=currentTarget.closest("li");app.showConfirmModal({title:app.vtranslate("JS_DELETE_INVENTORY_CONFIRMATION"),confirmedCallback:function confirmedCallback(){var progressIndicatorElement=$.progressIndicator({message:app.vtranslate("JS_SAVE_LOADER_INFO"),position:"html",blockInfo:{enabled:!0}}),editFields=liElement.find(".editFields");app.saveAjax("delete",null,{sourceModule:selectedModule,fieldName:editFields.data("name")}).done(function(response){var param={};response.result?(liElement.remove(),param={type:"success",text:app.vtranslate("JS_SAVE_CHANGES")}):param={type:"error",text:app.vtranslate("JS_ERROR")},Settings_Vtiger_Index_Js.showMessage(param),progressIndicatorElement.progressIndicator({mode:"hide"});});}});});},/**
		 * Loading list of fields for a related module
		 */loadMultiReferenceFields:function loadMultiReferenceFields(form){var thisInstance=this,module=form.find("[name=\"MRVModule\"]").val();form.find("[name=\"MRVField\"],[name=\"MRVFilterField\"]").select2("destroy"),form.find("[name=\"MRVField\"]").html(thisInstance.cacheMRVField.html()),form.find("[name=\"MRVField\"] optgroup").each(function(){$(this).data("module")!=module&&$(this).remove();}),form.find("[name=\"MRVFilterField\"]").html(thisInstance.cacheMRVFilter.html()),form.find("[name=\"MRVFilterField\"] option").each(function(){$(this).data("module")!=module&&$(this).remove();}),App.Fields.Picklist.showSelect2ElementView(form.find("[name=\"MRVField\"],[name=\"MRVFilterField\"]"),{width:"100%"});},cacheMRVField:!1,cacheMRVFilter:!1,/**
		 * Loading list of fields for a related module
		 */registerMultiReferenceFieldsChangeEvent:function registerMultiReferenceFieldsChangeEvent(form){var thisInstance=this;thisInstance.cacheMRVField=form.find("[name=\"MRVField\"]").clone(!0,!0),thisInstance.cacheMRVFilter=form.find("[name=\"MRVFilterField\"]").clone(!0,!0),form.find("[name=\"MRVModule\"]").on("change",function(){thisInstance.loadMultiReferenceFields(form);});},/**
		 * Loading list of fields for a related module
		 */registerMultiReferenceFilterFieldChangeEvent:function registerMultiReferenceFilterFieldChangeEvent(form){form.find("[name=\"MRVFilterField\"]").on("change",function(){var params={};params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.action="Field",params.mode="getPicklist",params.rfield=form.find("[name=\"MRVFilterField\"]").val(),params.rmodule=form.find("[name=\"MRVModule\"]").val(),form.find("[name=\"MRVFilterValue\"]").select2("destroy"),form.find("[name=\"MRVFilterValue\"] option").remove(),AppConnector.request(params).done(function(data){$.each(data.result,function(index,value){form.find("[name=\"MRVFilterValue\"]").append($("<option>").val(index).html(value));}),App.Fields.Picklist.showSelect2ElementView(form.find("[name=\"MRVFilterValue\"]"),{width:"100%"});});});},/**
		 * Register label copy
		 */registerCopyClipboard:function registerCopyClipboard(){new ClipboardJS(".copyFieldLabel",{text:function text(trigger){return app.showNotify({text:app.vtranslate("JS_NOTIFY_COPY_TEXT"),type:"success"}),$("#layoutEditorContainer").find("#"+trigger.getAttribute("data-target")).val()}});},/**
		 * Context help
		 */registerContextHelp:function registerContextHelp(){$(document).on("click",".js-context-help",function(e){var customConfig={toolbar:"Min"},element=$(e.currentTarget),progressInstance=$.progressIndicator({blockInfo:{enabled:!0}});AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),view:"HelpInfo",field:element.data("field-id")}).done(function(data){app.showModalWindow(data,function(modalContainer){progressInstance.progressIndicator({mode:"hide"}),app.showPopoverElementView(modalContainer.find(".js-help-info")),modalContainer.find(".js-lang").on("change",function(e){var previous=modalContainer.find(".js-editor:not([disabled])");App.Fields.Text.destroyEditor(previous),previous.closest(".js-context-block").addClass("d-none"),previous.prop("disabled",!0);var element=$(e.currentTarget).val(),textArea=modalContainer.find("#"+element+".js-context-area");textArea.prop("disabled",!1),textArea.closest(".js-context-block").removeClass("d-none"),App.Fields.Text.destroyEditor(textArea),modalContainer.find(".js-help-info").attr("data-content",textArea.val()),App.Fields.Text.Editor.register(textArea,customConfig);}),modalContainer.find("form").on("submit",function(e){e.preventDefault();var form=$(e.currentTarget),params=form.serializeFormData();"undefined"==typeof params.views&&(params.views=form.find("[name=\"views\"]").val()),app.saveAjax("contextHelp","",params).done(function(){app.showNotify({type:"success",text:app.vtranslate("JS_SAVE_CHANGES")});var prefix=form.find(".js-lang").val(),textArea=form.find("#"+prefix+".js-context-area");form.find(".js-help-info").attr("data-content",textArea.val()),"saveCloseButton"===e.originalEvent.submitter.name&&app.hideModalWindow();});});});});});},/**
		 * Register webservice apps events
		 */registerWebserviceAppsEvent:function registerWebserviceAppsEvent(){$(document).on("click",".js-edit-field-api",function(e){var element=$(e.currentTarget),progressInstance=$.progressIndicator({blockInfo:{enabled:!0}});AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),view:"WebserviceAppsModal",wa:element.data("wa"),fieldId:element.data("fieldId")}).done(function(data){app.showModalWindow(data,function(modalContainer){progressInstance.progressIndicator({mode:"hide"}),modalContainer.find(".js-default-value").on("change",function(e){var currentTarget=$(e.currentTarget),defaultValueUi=currentTarget.closest(".js-modal-form").find(".js-default-value-container");currentTarget.is(":checked")?defaultValueUi.removeClass("d-none"):defaultValueUi.addClass("d-none");}),modalContainer.find(".js-modal__save").on("click",function(){modalContainer.find(".js-modal-form").trigger("submit"),element.closest("li").addClass("u-bg-gray");});});});});},/**
		 * register events for layout editor
		 */registerEvents:function registerEvents(){this.container=$("#layoutEditorContainer"),this.registerBlockEvents(),this.registerFieldEvents(),this.setInactiveFieldsList(),this.registerAddCustomBlockEvent(),this.relatedModulesTabClickEvent(),this.registerModulesChangeEvent(),this.registerRelModulesChangeEvent(),1===$("#relatedTabOrder").length&&(this.registerRelatedListEvents(),this.makeRelatedModuleSortable()),this.registerSwitch(),this.registerAddInventoryField(),this.registerEditInventoryField(),this.registerInventoryFieldSequenceSaveClick(),this.registerDeleteInventoryField(),this.registerFieldSequenceSaveClick();},registerBasicEvents:function registerBasicEvents(){this.registerEvents(),this.registerCopyClipboard(),this.registerContextHelp(),this.registerWebserviceAppsEvent();}}),jQuery(function(){var instance=new Settings_LayoutEditor_Js;instance.registerBasicEvents();}),Vtiger_WholeNumberGreaterThanZero_Validator_Js("Vtiger_FloatingDigits_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var rangeInstance=new Vtiger_FloatingDigits_Validator_Js;rangeInstance.setElement(field);var response=rangeInstance.validate();if(!0!=response)return rangeInstance.getError()}},{/**
		 * Function to validate the decimals length
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var response=this._super();if(!0!=response)return response;var fieldValue=this.getFieldValue();if(2>fieldValue||5<fieldValue){var errorInfo=app.vtranslate("JS_PLEASE_ENTER_NUMBER_IN_RANGE_2TO5");return this.setError(errorInfo),!1}if(/^[+]/.test(fieldValue)){var error=app.vtranslate("JS_CONTAINS_ILLEGAL_CHARACTERS");return this.setError(error),!1}return !0}}),Vtiger_WholeNumberGreaterThanZero_Validator_Js("Vtiger_DecimalMaxLength_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var rangeInstance=new Vtiger_DecimalMaxLength_Validator_Js;rangeInstance.setElement(field);var response=rangeInstance.validate();if(!0!=response)return rangeInstance.getError()}},{/**
		 * Function to validate the fieldLength
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var response=this._super();if(!0!=response)return response;var fieldValue=this.getFieldValue(),decimalFieldValue=$("#createFieldForm").find("[name=\"decimal\"]").val(),fieldLength=parseInt(64)-parseInt(decimalFieldValue);if(fieldValue>fieldLength&&!(0>fieldLength)&&59<=fieldLength){var errorInfo=app.vtranslate("JS_LENGTH_SHOULD_BE_LESS_THAN_EQUAL_TO")+" "+fieldLength;return this.setError(errorInfo),!1}if(/^[+]/.test(fieldValue)){var error=app.vtranslate("JS_CONTAINS_ILLEGAL_CHARACTERS");return this.setError(error),!1}return !0}}),Vtiger_WholeNumberGreaterThanZero_Validator_Js("Vtiger_MaxLength_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var rangeInstance=new Vtiger_DecimalMaxLength_Validator_Js;rangeInstance.setElement(field);var response=rangeInstance.validate();if(!0!=response)return rangeInstance.getError()}},{/**
		 * Function to validate the fieldLength
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var response=this._super();if(!0!=response)return response;var fieldValue=this.getFieldValue();if(255<fieldValue){var errorInfo=app.vtranslate("JS_LENGTH_SHOULD_BE_LESS_THAN_EQUAL_TO")+" 255";return this.setError(errorInfo),!1}if(/^[+]/.test(fieldValue)){var error=app.vtranslate("JS_CONTAINS_ILLEGAL_CHARACTERS");return this.setError(error),!1}return !0}}),Vtiger_Base_Validator_Js("Vtiger_FieldLabel_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var instance=new Vtiger_FieldLabel_Validator_Js;instance.setElement(field);var response=instance.validate();if(!0!=response)return instance.getError()}},{/**
		 * Function to validate the field label
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var fieldValue=this.getFieldValue();return this.validateValue(fieldValue)},validateValue:function validateValue(fieldValue){if(/[&\<\>\:\'\"\,]/.test(fieldValue)){var errorInfo=app.vtranslate("JS_SPECIAL_CHARACTERS")+" & < > ' \" : , "+app.vtranslate("JS_NOT_ALLOWED");return this.setError(errorInfo),!1}return !0}}),Vtiger_Base_Validator_Js("Vtiger_PicklistFieldValues_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var instance=new Vtiger_PicklistFieldValues_Validator_Js;instance.setElement(field);var response=instance.validate();if(!0!=response)return instance.getError()}},{/**
		 * Function to validate the field label
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){return this.validateValue(this.getElement().val())},validateValue:function validateValue(fieldValue){var _this8=this,specialChars=/[\<\>\"\,\#]/,r=!0;return $.each(fieldValue,function(i,val){specialChars.test(val)&&(_this8.setError(app.vtranslate("JS_SPECIAL_CHARACTERS")+" < > \" , # "+app.vtranslate("JS_NOT_ALLOWED")),r=!1);}),r}});
//# sourceMappingURL=LayoutEditor.min.js.map
