<?php
/**
 * Selected field view.
 *
 * @package   Views
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Adrian Kon <a.kon@yetiforce.com>
 */

/**
 * Selected column option view.
 */
class ReportTemplate_SelectedField_View extends \App\Controller\View\Page
{
	/** {@inheritdoc} */
	public function checkPermission(App\Request $request)
	{
		if (!Users_Privileges_Model::getCurrentUserPrivilegesModel()->hasModulePermission($request->getModule())) {
			throw new \App\Exceptions\NoPermitted('LBL_PERMISSION_DENIED', 406);
		}
	}

	/** {@inheritdoc} */
	public function process(App\Request $request)
	{
		$viewer = $this->getViewer($request);
		$viewer->assign('FORMULA_ID', $request->getInteger('formulaId'));
		$viewer->assign('FORMULA_COLUMN_ID', $request->getInteger('formulaColumnId'));
		$viewer->assign('ICON', $request->getByType('icon', App\Purifier::TEXT));
		$viewer->assign('FIELD_FUNCTION', $request->getByType('function', App\Purifier::TEXT));
		$viewer->assign('FIELD_EXPRESSION', $request->getByType('fieldExpression', App\Purifier::TEXT));
		$viewer->assign('SELECTED_FIELD', $request->getByType('selectedField', App\Purifier::TEXT));
		$viewer->assign('ORDER_BY', $request->getByType('orderBy', App\Purifier::TEXT));
		echo $viewer->view('SelectedField.tpl', $request->getModule(), true);
	}
}
