<?php
/**
 * Render template with data.
 *
 * @package   ReportTemplates
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Paweł Karczmarcyk <p.karczmarczyk@yetiforce.com>
 */

use App\Controller\View\Page;
use App\Request;

class ReportTemplate_Preview_View extends Page
{
	/** {@inheritdoc} */
	public function checkPermission(App\Request $request): void
	{
		if (!Users_Privileges_Model::getCurrentUserPrivilegesModel()->hasModulePermission($request->getModule())) {
			throw new \App\Exceptions\NoPermitted('LBL_PERMISSION_DENIED', 406);
		}
	}

	/**
	 * @param Request $request
	 *
	 * @return void
	 */
	public function process(App\Request $request): void
	{
		$viewer = $this->getViewer($request);
		$viewer->assign('PREVIEW_DATA', $request->getArray('previewData', App\Purifier::TEXT));
		$viewer->assign('PREVIEW_HEADERS', $request->getArray('previewHeadersData', App\Purifier::TEXT));
		echo $viewer->view('Preview.tpl', $request->getModule(), true);
	}
}
