<?php

/**
 * Check errors while sending the message file.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\SystemWarnings\Integrations;

/**
 * Check for errors while sending the message class.
 */
class Comarch extends \App\SystemWarnings\Template
{
    /** {@inheritdoc} */
    protected $title = 'LBL_CHECK_COMARCH_INTEGRATION_LOG';

    /**
     * Checks for suspended email accounts.
     *
     * @return void
     */
    public function process(): void
    {
        $db = \App\DB::getInstance('log');
        if(!$db->isTableExists(\App\Integrations\Comarch::LOG_TABLE_NAME)) {
            $this->status = 1;
            return;
        }
        $data = (new \App\Db\Query())->select(['time', 'message'])->from(\App\Integrations\Comarch::LOG_TABLE_NAME)
            ->where([
                'and',
                ['error' => 1],
                ['>=', 'time', date('Y-m-d H:i:s', strtotime('-24 hours'))]
            ])->orderBy(['id' => SORT_DESC])
            ->all($db);
        if ($data) {
            $this->status = 0;
            $this->description = \App\Language::translate('LBL_CHECK_COMARCH_INTEGRATION_LOG_DESC', 'Settings:SystemWarnings');
            $this->description .= '<br>' . \App\TextUtils::getHtmlTable($data, [
                'time' => \App\Language::translate('LBL_TIME', 'Settings:Log'),
                'message' => \App\Language::translate('LBL_MESSAGE', 'Settings:Comarch')
            ]);
            if (\App\Security\AdminAccess::isPermitted('Log')) {
                $this->link = 'index.php?parent=Settings&module=Log&view=LogsViewer&type=mail';
                $this->linkTitle = \App\Language::translate('LBL_LOGS_VIEWER', 'Settings:Log');
            }
        } else {
            $this->status = 1;
        }
    }
}
