<?php
/**
 * OAuth sso authorization api file.
 *
 * @package API
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

namespace Api\OAuth\SSO;

use App\Purifier;

class AzureAD extends \Api\Core\BaseAction
{
	/** {@inheritdoc}  */
	public $allowedMethod = ['GET'];

	/** {@inheritdoc} */
	public function updateSession(array $data = []): void
	{
	}

	/**
	 * @OA\Get(
	 *		path="/webservice/OAuth/SSO/AzureAD",
	 *		summary="OAuth SSO authorization api",
	 *		@OA\Response(response=200, description="Result"),
	 * ),
	 *
	 * @return void
	 */
	public function get()
	{
		$code = $this->controller->request->getRaw('code');
		$state = $this->controller->request->get('state');
		$provider = $this->controller->request->getByType('action', Purifier::ALNUM);
		$redirectUri = \Config\Main::$site_URL . "index.php?module=Users&action=Login&mode=auth&provider={$provider}&code={$code}&state={$state}";

		header('location: ' . $redirectUri);
		exit;
	}

	/** {@inheritdoc}  */
	protected function checkPermission(): void
	{
	}

	/** {@inheritdoc}  */
	protected function checkPermissionToModule(): void
	{
	}
}
