'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}function _defineProperties(target,props){for(var descriptor,i=0;i<props.length;i++)descriptor=props[i],descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}function _createClass(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Object.defineProperty(Constructor,"prototype",{writable:!1}),Constructor}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return "symbol"==_typeof(i)?i:i+""}function _toPrimitive(t,r){if("object"!=_typeof(t)||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=_typeof(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return ("string"===r?String:Number)(t)}var MultiImage=/*#__PURE__*/function(){/**
	 * Create class instance
	 *
	 * @param {HTMLElement|jQuery} inputElement - input type file element inside component
	 */function MultiImage(element){_classCallCheck(this,MultiImage);var thisInstance=this;this.elements={},this.options={showCarousel:!0},this.detailView=!1,this.elements.fileInput=element.find(".js-multi-image__file").eq(0),0===this.elements.fileInput.length&&(this.detailView=!0),this.elements.component=element.eq(0),this.elements.form=element.closest("form").eq(0),$(this.elements.form).on("submit",this.onFormSubmit),this.elements.addButton=this.elements.component.find(".js-multi-image__file-btn").eq(0),this.elements.values=this.elements.component.find(".js-multi-image__values").eq(0),this.elements.progressBar=this.elements.component.find(".js-multi-image__progress-bar").eq(0),this.elements.progress=this.elements.component.find(".js-multi-image__progress").eq(0),this.elements.result=this.elements.component.find(".js-multi-image__result").eq(0),this.fieldInfo=this.elements.values.data("fieldinfo"),this.options.formats=this.fieldInfo.formats,this.options.limit=this.fieldInfo.limit,this.options.maxFileSize=this.fieldInfo.maxFileSize||CONFIG.maxUploadLimit,this.options.maxFileSizeDisplay=this.fieldInfo.maxFileSizeDisplay||"",this.files=this.detailView?this.elements.values.data("value"):JSON.parse(this.elements.values.val()),this.detailView||(this.elements.fileInput.detach(),this.elements.addButton.click(this.addButtonClick.bind(this)),this.elements.fileInput.fileupload({dataType:"json",replaceFileInput:!1,fileInput:this.fileInput,autoUpload:!1,submit:this.submit.bind(this),add:this.add.bind(this),progressall:this.progressAll.bind(this),change:this.change.bind(this),drop:this.change.bind(this),dragover:this.dragOver.bind(this),fail:this.uploadError.bind(this),done:this.uploadSuccess.bind(this)}),this.elements.component.on("dragleave",this.dragLeave.bind(this)),this.elements.component.on("dragend",this.dragLeave.bind(this)),this.elements.fileInput.fileupload("option","dropZone",$(this.elements.component)),this.enableDragNDrop()),this.elements.component.on("click",".js-multi-image__popover-img",function(){thisInstance.zoomPreview($(this).data("hash"));}),this.elements.component.on("click",".js-multi-image__popover-btn-zoom",function(e){e.preventDefault(),thisInstance.zoomPreview($(this).data("hash"));}),this.elements.component.on("click",".js-multi-image__popover-btn-download",function(e){e.preventDefault(),thisInstance.download($(this).data("hash"));}),this.detailView||this.elements.component.on("click",".js-multi-image__popover-btn-delete",function(e){e.preventDefault(),thisInstance.deleteFile($(this).data("hash"));}),this.loadExistingFiles();}/**
	 * Prevent form submission before file upload end
	 * @param e
	 */return _createClass(MultiImage,[{key:"onFormSubmit",value:function onFormSubmit(e){return !App.Fields.MultiImage.currentFileUploads||(e.preventDefault(),e.stopPropagation(),e.stopImmediatePropagation(),app.showAlert(app.vtranslate("JS_WAIT_FOR_FILE_UPLOAD")),!1)}/**
	 * Prevent form submission
	 *
	 * @param {Event} e
	 */},{key:"addButtonClick",value:function addButtonClick(e){e.preventDefault(),this.elements.fileInput.trigger("click");}/**
	 * Submit event handler from jQuery-file-upload
	 *
	 * @param {Event} e
	 * @param {Object} data
	 */},{key:"submit",value:function submit(_e,data){data.formData={hash:data.files[0].hash},App.Fields.MultiImage.currentFileUploads++,this.progressInstance=$.progressIndicator({position:"replace",blockInfo:{enabled:!0,elementToBlock:this.elements.component}});}/**
	 * Get file information
	 *
	 * @param {String} hash - file id
	 * @returns {Object}
	 */},{key:"getFileInfo",value:function getFileInfo(hash){for(var file,i=0,len=this.files.length;i<len;i++)if(file=this.files[i],file.hash===hash)return file;app.errorLog("File '".concat(hash,"' not found.")),app.showNotify({text:app.vtranslate("JS_INVALID_FILE_HASH")+" [".concat(hash,"]"),type:"error"});}/**
	 * Add property to file info object
	 *
	 * @param {String} hash - file id
	 * @param {String} propertyName
	 * @param {any} value
	 * @returns {Object}
	 */},{key:"addFileInfoProperty",value:function addFileInfoProperty(hash,propertyName,value){var fileInfo=this.getFileInfo(hash);return fileInfo[propertyName]=value,fileInfo}/**
	 * Error event handler from file upload request
	 *
	 * @param {Event} e
	 * @param {Object} data
	 */},{key:"uploadError",value:function uploadError(_e,data){var _this=this;this.progressInstance.progressIndicator({mode:"hide"}),app.errorLog("File upload error.");var jqXHR=data.jqXHR,files=data.files,response=jqXHR.responseJSON;// first try to show error for concrete file
return null!==response&&"undefined"!=typeof response&&"undefined"!=typeof response.result&&"undefined"!=typeof response.result.attach&&Array.isArray(response.result.attach)?(response.result.attach.forEach(function(fileAttach){App.Fields.MultiImage.currentFileUploads--,_this.deleteFile(fileAttach.hash,!1),"string"==typeof fileAttach.error?app.showNotify({textTrusted:!1,text:fileAttach.error,type:"error"}):app.showNotify({textTrusted:!1,title:app.vtranslate("JS_FILE_UPLOAD_ERROR"),text:fileAttach.name,type:"error"});}),void this.updateFormValues()):void(// else show default upload error
files.forEach(function(file){App.Fields.MultiImage.currentFileUploads--,_this.deleteFile(file.hash,!1),app.showNotify({textTrusted:!1,title:app.vtranslate("JS_FILE_UPLOAD_ERROR"),text:file.name,type:"error"});}),this.updateFormValues())}/**
	 * Success event handler from file upload request
	 *
	 * @param {Event} e
	 * @param {Object} data
	 */},{key:"uploadSuccess",value:function uploadSuccess(e,data){var _this2=this;this.progressInstance.progressIndicator({mode:"hide"});var result=data.result,attach=result.result.attach;attach.forEach(function(fileAttach){var hash=fileAttach.hash;if(!hash)return app.errorLog(new Error(app.vtranslate("JS_INVALID_FILE_HASH")));if("undefined"==typeof fileAttach.key)return _this2.uploadError(e,data);"undefined"!=typeof fileAttach.info&&fileAttach.info&&app.showNotify({textTrusted:!1,type:"notice",title:fileAttach.info,text:fileAttach.name});var fileInfo=_this2.getFileInfo(hash);_this2.addFileInfoProperty(hash,"key",fileAttach.key),_this2.addFileInfoProperty(hash,"size",fileAttach.size),_this2.addFileInfoProperty(hash,"sizeDisplay",fileAttach.sizeDisplay||fileAttach.size),_this2.addFileInfoProperty(hash,"name",fileAttach.name),_this2.addFileInfoProperty(hash,"type",fileAttach.type||""),_this2.generatePreviewFromFile(fileInfo.file,function(template,imageSrc){_this2.addFileInfoProperty(hash,"previewElement",_this2.addPreviewPopover(fileInfo,template,imageSrc)),_this2.redraw();}),App.Fields.MultiImage.currentFileUploads--;}),this.updateFormValues();}/**
	 * Update form input values
	 */},{key:"updateFormValues",value:function updateFormValues(){this.elements.fileInput.val(null);var formValues=this.files.map(function(file){return {key:file.key,name:file.name,size:file.size,type:file.type||""}});this.elements.values.val(JSON.stringify(formValues));}/**
	 * Validate file
	 *
	 * @param {Object} file
	 * @returns {boolean}
	 */},{key:"validateFormat",value:function validateFormat(file){var valid=!1;return this.options.formats.forEach(function(format){file.type==="image/"+format&&(valid=!0);}),valid||app.showNotify({title:"".concat(app.vtranslate("JS_INVALID_FILE_TYPE")),text:"".concat(app.vtranslate("JS_AVAILABLE_FILE_TYPES"),": ").concat(this.options.formats.join(", ")),type:"error"}),valid}/**
	 * Validate maximum file size
	 * @param {Object} file
	 * @returns {Boolean}
	 */},{key:"validateSize",value:function validateSize(file){var result="number"==typeof file.size&&file.size<this.options.maxFileSize;return result||app.showNotify({text:"".concat(app.vtranslate("JS_UPLOADED_FILE_SIZE_EXCEEDS")," <br> [").concat(this.options.maxFileSizeDisplay,"]"),type:"error"}),result}/**
	 * Show limit error
	 */},{key:"showLimitError",value:function showLimitError(){this.elements.fileInput.val(""),app.showNotify({text:"".concat(app.vtranslate("JS_FILE_LIMIT")," [").concat(this.options.limit,"]"),type:"error"});}/**
	 * Get only valid files from list
	 *
	 * @param {Array} files
	 * @returns {Array}
	 */},{key:"filterValidFiles",value:function filterValidFiles(files){var _this3=this;return files.length+this.files.length>this.options.limit?(this.showLimitError(),[]):files.filter(function(file){return _this3.validateFormat(file)&&_this3.validateSize(file)})}/**
	 * Set files hash
	 * @param {Array} files
	 * @returns {Array}
	 */},{key:"setFilesHash",value:function setFilesHash(files){for(var file,addedFiles=[],i=0,len=files.length;i<len;i++)if(file=files[i],"undefined"==typeof file.hash)if(this.files.length<this.options.limit)file.hash=App.Fields.Text.generateRandomHash(CONFIG.userId),this.files.push({hash:file.hash,imageSrc:file.imageSrc,name:file.name,file:file}),addedFiles.push(file);else return this.showLimitError(),addedFiles;return addedFiles}/**
	 * Add event handler from jQuery-file-upload
	 *
	 * @param {Event} e
	 * @param {object} data
	 */},{key:"add",value:function add(_e,data){0<data.files.length&&data.submit();}/**
	 * Progressall event handler from jQuery-file-upload
	 *
	 * @param {Event} e
	 * @param {Object} data
	 */},{key:"progressAll",value:function progressAll(_e,data){var _this4=this,progress=parseInt(100*(data.loaded/data.total),10);this.elements.progressBar.css({width:progress+"%"}),100===progress?setTimeout(function(){_this4.elements.progress.addClass("d-none"),_this4.elements.progressBar.css({width:"0%"});},1e3):this.elements.progress.removeClass("d-none");}/**
	 * Dragover event handler from jQuery-file-upload
	 *
	 * @param {Event} e
	 */},{key:"dragOver",value:function dragOver(){this.elements.component.addClass("c-multi-image__drop-effect");}/**
	 * Dragleave event handler
	 * @param {Event} e
	 */},{key:"dragLeave",value:function dragLeave(){this.elements.component.removeClass("c-multi-image__drop-effect");}/**
	 * Download file according to source type (base64/file from server)
	 *
	 * @param {String} hash
	 */},{key:"download",value:function download(hash){var fileInfo=this.getFileInfo(hash);return "file.php"===fileInfo.imageSrc.substr(0,8).toLowerCase()?this.downloadFile(hash):this.downloadBase64(hash)}/**
	 * Download file that exists on the server already
	 * @param {String} hash
	 */},{key:"downloadFile",value:function downloadFile(hash){var fileInfo=this.getFileInfo(hash),link=document.createElement("a");$(link).css("display","none"),"string"==typeof link.download?(document.body.appendChild(link),link.download=fileInfo.name,link.href=fileInfo.imageSrc,link.click(),document.body.removeChild(link)):location.replace(fileInfo.imageSrc);}/**
	 * Download file from base64 image
	 *
	 * @param {String} hash
	 */},{key:"downloadBase64",value:function downloadBase64(hash){var fileInfo=this.getFileInfo(hash),imageUrl="data:application/octet-stream;filename=".concat(fileInfo.name,";base64,")+fileInfo.imageSrc.split(",")[1],link=document.createElement("a");$(link).css("display","none"),"string"==typeof link.download?(document.body.appendChild(link),link.download=fileInfo.name,link.href=imageUrl,link.click(),document.body.removeChild(link)):location.replace(imageUrl);}/**
	 * Display modal window with large preview
	 *
	 * @param {string} hash
	 */},{key:"zoomPreview",value:function zoomPreview(hash){var self=this,fileInfo=this.getFileInfo(hash),titleTemplate=function(){var titleObject=document.createElement("span"),icon=document.createElement("i");return icon.setAttribute("class","fa fa-image"),titleObject.appendChild(icon),titleObject.appendChild(document.createTextNode(" ".concat(fileInfo.name))),titleObject.innerHTML},buttons=[];self.detailView||buttons.push({text:app.vtranslate("JS_DELETE"),icon:"fa fa-trash-alt",class:"float-left btn btn-outline-primary js-delete"}),buttons.push({text:app.vtranslate("JS_DOWNLOAD"),icon:"fa fa-download",class:"float-left btn btn-primary js-success"},{text:app.vtranslate("JS_CLOSE"),icon:"fa fa-times",class:"btn btn-outline-primary",data:{dismiss:"modal"}}),app.showModalHtml({class:"modal-lg",header:titleTemplate(),footerButtons:buttons,body:self.options.showCarousel?self.generateCarousel(hash):"<img src=\"".concat(fileInfo.imageSrc,"\" class=\"w-100\" />"),cb:function cb(modal){modal.on("click",".js-delete",function(){self.deleteFile(fileInfo.hash),app.hideModalWindow();}),modal.on("click",".js-success",function(){self.download(fileInfo.hash),app.hideModalWindow();}),self.options.showCarousel&&modal.find("#carousel-".concat(hash)).on("slid.bs.carousel",function(e){fileInfo=self.getFileInfo($(e.relatedTarget).data("hash")),modal.find(".js-modal-title").html(titleTemplate());});}});}/**
	 * Remove file from preview and from file list
	 *
	 * @param {String} hash
	 */},{key:"deleteFileCallback",value:function deleteFileCallback(hash){var fileInfo=this.getFileInfo(hash);fileInfo.previewElement&&fileInfo.previewElement.popover("dispose").remove(),this.files=this.files.filter(function(file){return file.hash!==fileInfo.hash}),this.updateFormValues();}/**
	 * Delete image from input field
	 * Should be called with this pointing on button element with data-hash attribute
	 *
	 * @param {string} hash
	 * @param {boolean} showConfirmation - dialog?
	 */},{key:"deleteFile",value:function deleteFile(hash){var _this5=this,showConfirmation=!(1<arguments.length&&arguments[1]!==void 0)||arguments[1];if(showConfirmation){var fileInfo=this.getFileInfo(hash);app.showConfirmModal({title:fileInfo.name,text:app.vtranslate("JS_DELETE_FILE_CONFIRMATION"),titleTrusted:!1,icon:"fa fa-trash-alt",confirmedCallback:function confirmedCallback(){_this5.deleteFileCallback(hash);}});}else this.deleteFileCallback(hash);}/**
	 * File change event handler from jQuery-file-upload
	 *
	 * @param {Event} e
	 * @param {object} data
	 */},{key:"change",value:function change(e,data){data.files=this.filterValidFiles(data.files),data.files=this.setFilesHash(data.files),this.dragLeave(e);}/**
	 * Generate and apply popover to preview
	 *
	 * @param {File} file
	 * @param {string} template
	 * @param {string} imageSrc
	 * @returns {jQuery}
	 */},{key:"addPreviewPopover",value:function addPreviewPopover(file,template,imageSrc){var thisInstance=this,fileSize="",fileInfo=this.getFileInfo(file.hash),size=fileInfo.sizeDisplay||fileInfo.size;size&&(fileSize="<div class=\"p-1 bg-white border rounded small position-absolute\">".concat(size,"</div>"));var deleteBtn="";this.detailView||(deleteBtn="<button class=\"btn btn-outline-primary c-btn-collapsible js-multi-image__popover-btn-delete\" type=\"button\" data-hash=\"".concat(file.hash,"\" data-js=\"click\"><i class=\"fa fa-trash-alt\"></i> <span class=\"c-btn-collapsible__text\">").concat(app.vtranslate("JS_DELETE"),"</span></button>"));var titleObject=document.createElement("span");return titleObject.appendChild(document.createTextNode(fileInfo.name)),$(template).popover({container:thisInstance.elements.component,title:"<div class=\"u-text-ellipsis\"><i class=\"fa fa-image\"></i> "+titleObject.innerHTML+"</div>",html:!0,sanitize:!1,trigger:"click",placement:"top",content:"<img src=\"".concat(imageSrc,"\" class=\"w-100 js-multi-image__popover-img c-multi-image__popover-img\" data-hash=\"").concat(file.hash,"\" data-js=\"click\"/>"),template:"<div class=\"popover popover--multiImage\" role=\"tooltip\">\n\t\t\t\t<div class=\"arrow\"></div>\n\t\t\t\t<h3 class=\"popover-header\"></h3>\n\t\t\t\t<div class=\"popover-body\"></div>\n\t\t\t\t<div class=\"text-right popover-footer js-multi-image__popover-actions\">\n\t\t\t\t\t".concat(fileSize,"\n\t\t\t\t\t").concat(deleteBtn,"\n\t\t\t\t\t<button class=\"btn btn-primary c-btn-collapsible js-multi-image__popover-btn-download\" type=\"button\" data-hash=\"").concat(file.hash,"\" data-js=\"click\"><i class=\"fa fa-download\"></i> <span class=\"c-btn-collapsible__text\">").concat(app.vtranslate("JS_DOWNLOAD"),"</span></button>\n\t\t\t\t\t<button class=\"btn btn-primary c-btn-collapsible js-multi-image__popover-btn-zoom\" type=\"button\" data-hash=\"").concat(file.hash,"\" data-js=\"click\"><i class=\"fa fa-search-plus\"></i> <span class=\"c-btn-collapsible__text\">").concat(app.vtranslate("JS_ZOOM_IN"),"</span></button>\n\t\t\t\t</div>\n\t\t\t</div>")})}/**
	 * Remove preview popover
	 *
	 * @param {String} hash
	 */},{key:"removePreviewPopover",value:function removePreviewPopover(hash){var fileInfo=this.getFileInfo(hash);"undefined"!=typeof fileInfo.previewElement&&fileInfo.previewElement.popover("dispose");}/**
	 * Hide popovers when user starts moving file preview
	 *
	 * @param {Event} e
	 * @param {Object} ui
	 */},{key:"sortOver",value:function sortOver(){this.elements.result.find(".js-multi-image__preview").popover("hide");}/**
	 * Update file position according to elements order
	 *
	 * @param {Event} e
	 * @param {Object} ui
	 */},{key:"sortStop",value:function sortStop(){var _this6=this,actualElements=this.elements.result.find(".js-multi-image__preview").toArray();this.files=actualElements.map(function(element){for(var elementHash,i=0,len=_this6.files.length;i<len;i++)if(elementHash=$(element).data("hash"),_this6.files[i].hash===elementHash)return _this6.files[i]}),this.redraw();}/**
	 * Redraw view according to in-memory positions
	 */},{key:"redraw",value:function redraw(){var _this7=this;this.files.forEach(function(file){_this7.elements.result.append(file.previewElement);}),this.updateFormValues();}/**
	 * Enable drag and drop files repositioning
	 */},{key:"enableDragNDrop",value:function enableDragNDrop(){this.elements.result.sortable({handle:".js-multi-image__preview-img",items:".js-multi-image__preview",over:this.sortOver.bind(this),stop:this.sortStop.bind(this)}).disableSelection().on("mousedown",".js-multi-image__preview-img",function(){this.focus();});}/**
	 * Generate preview of images and append to multi image results view
	 *
	 * @param {Array} files - array of Files
	 * @param {function} callback
	 */},{key:"generatePreviewElements",value:function generatePreviewElements(files,callback){var _this8=this,preview=function(file,template,imageSrc){file.preview=_this8.addPreviewPopover(file,template,imageSrc),_this8.addFileInfoProperty(file.hash,"previewElement",file.preview),callback(file.preview);};files.forEach(function(file){file instanceof File?_this8.generatePreviewFromFile(file,function(template,imageSrc){preview(file,template,imageSrc);}):_this8.generatePreviewFromValue(file,function(template,imageSrc){preview(file,template,imageSrc);});});}/**
	 * Generate preview of image as html string
	 *
	 * @param {File} file
	 * @param {function} callback
	 */},{key:"generatePreviewFromFile",value:function generatePreviewFromFile(file,callback){var _this9=this,fr=new FileReader;fr.onload=function(){file.imageSrc=fr.result,_this9.addFileInfoProperty(file.hash,"imageSrc",file.imageSrc),callback(_this9.createPreview(file),fr.result);},fr.readAsDataURL(file);}/**
	 * Generate preview of image as html string from existing values
	 *
	 * @param {File} file
	 * @param {function} callback
	 */},{key:"generatePreviewFromValue",value:function generatePreviewFromValue(file,callback){callback(this.createPreview(file),file.imageSrc);}/**
	 * Create Preview element
	 * @param {Object} file
	 * @returns {String}
	 */},{key:"createPreview",value:function createPreview(file){var container=document.createElement("div"),item=document.createElement("div");item.setAttribute("class","d-inline-block mr-1 js-multi-image__preview"),item.setAttribute("id","js-multi-image__preview-hash-".concat(file.hash)),item.setAttribute("data-hash",file.hash);var subElement=document.createElement("div");return subElement.setAttribute("class","img-thumbnail js-multi-image__preview-img c-multi-image__preview-img"),subElement.setAttribute("data-hash",file.hash),subElement.setAttribute("style","background-image:url(".concat(file.imageSrc,")")),subElement.setAttribute("tabindex","0"),subElement.setAttribute("title",file.name),item.appendChild(subElement),container.appendChild(item),container.innerHTML}/**
	 * Load files that were in valueInput as json string
	 */},{key:"loadExistingFiles",value:function loadExistingFiles(){var _this10=this;this.files=this.files.map(function(file){return file.hash=App.Fields.Text.generateRandomHash(CONFIG.userId),file}).slice(0,this.options.limit),this.generatePreviewElements(this.files,function(element){_this10.elements.result.append(element);}),this.updateFormValues();}/**
	 * Generate carousel for all files in large preview
	 *
	 * @param {String} hash
	 */},{key:"generateCarousel",value:function generateCarousel(hash){if(1>=this.files.length){var fileInfo=this.getFileInfo(hash);return "<img class=\"d-block w-100\" src=\"".concat(fileInfo.imageSrc,"\">")}var template="<div id=\"carousel-".concat(hash,"\" class=\"carousel slide c-carousel\" data-ride=\"carousel\" data-js=\"container\">\n\t\t  <div class=\"carousel-inner\">");return this.files.forEach(function(file){template+="<div class=\"carousel-item c-carousel__item",file.hash===hash&&(template+=" active"),template+="\" data-hash=\"".concat(file.hash,"\">\n\t\t      <img class=\"d-block w-100 c-carousel__image\" src=\"").concat(file.imageSrc,"\">\n\t\t    </div>");}),template+="<a class=\"carousel-control-prev c-carousel__prevnext-btn c-carousel__prev-btn\" href=\"#carousel-".concat(hash,"\" role=\"button\" data-slide=\"prev\" data-js=\"click\">\n\t\t    <span class=\"fas fa-caret-left fa-2x c-carousel__prev-icon mr-1\" aria-hidden=\"true\"></span>\n\t\t  </a>\n\t\t  <a class=\"carousel-control-next c-carousel__prevnext-btn c-carousel__next-btn\" href=\"#carousel-").concat(hash,"\" role=\"button\" data-slide=\"next\" data-js=\"click\">\n\t\t    <span class=\"fas fa-caret-right fa-2x c-carousel__next-icon ml-1\" aria-hidden=\"true\"></span>\n\t\t  </a>\n\t\t</div>"),template}}])}();
//# sourceMappingURL=MultiImage.min.js.map
