/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */
'use strict';
$.Class(
	'OSSMailView_MailsPreview_Js',
	{},
	{
		detailsContainer: null,
		/**
		 * Register modal events
		 * @param {jQuery} modalContainer
		 */
		registerEvents: function (modalContainer) {
			Vtiger_Index_Js.registerMailButtons(modalContainer);

			modalContainer
				.find('.expandAllMails')
				.off('click')
				.on('click', function (e) {
					modalContainer.find('.mailBody').removeClass('d-none');
					modalContainer.find('.mailTeaser').addClass('d-none');
					modalContainer.find('.showMailBody .js-toggle-icon').removeClass('fa-caret-down').addClass('fa-caret-up');
				});
			modalContainer
				.find('.collapseAllMails')
				.off('click')
				.on('click', function (e) {
					modalContainer.find('.mailBody').addClass('d-none');
					modalContainer.find('.mailTeaser').removeClass('d-none');
					modalContainer.find('.showMailBody .js-toggle-icon').removeClass('fa-caret-up').addClass('fa-caret-down');
				});

			modalContainer
				.find('.showMailModal')
				.off('click')
				.on('click', function (e) {
					e.preventDefault();
					let progressIndicatorElement = jQuery.progressIndicator();
					app.showModalWindow('', $(e.currentTarget).data('url') + '&noloadlibs=1', function (data) {
						Vtiger_Index_Js.registerMailButtons(data);
						progressIndicatorElement.progressIndicator({ mode: 'hide' });
					});
				});

			modalContainer
				.off('click', '.showMailBody')
				.on('click', '.showMailBody', (e) => {
					let row = $(e.currentTarget).closest('.js-mail-row');
					let mailBody = row.find('.mailBody');
					let mailTeaser = row.find('.mailTeaser');

					mailBody.toggleClass('d-none');
					mailTeaser.toggleClass('d-none');
				});

			modalContainer
				.find('.js-next-page')
				.off('click')
				.on('click', (e) => {
					let self = this;
					self.jumpToNextPage(e);
				});
			modalContainer
				.find('.js-page--previous')
				.off('click')
				.on('click', (e) => {
					let self = this;
					self.jumpToPreviousPage(e);
				});
			modalContainer
				.find('.pageNumber')
				.off('click')
				.on('click', (e) => {
					let self = this;
					self.jumpToClickedPage(e);
				});
			modalContainer
				.find('.firstPage')
				.off('click')
				.on('click', (e) => {
					let self = this;
					self.jumpToClickedPage(e);
				});
			modalContainer
				.find('.lastPage')
				.off('click')
				.on('click', (e) => {
					let self = this;
					self.jumpToClickedPage(e);
				});
			modalContainer
				.find('.js-page--jump-drop-down')
				.off('click', 'li')
				.on('click', 'li', (e) => {
					e.stopImmediatePropagation();
				})
				.off('keypress', '.js-page-jump')
				.on('keypress', '.js-page-jump', (e) => {
					let self = this;
					self.jumpToInputPage(e);
				});
		},
		/**
		 * Jump to clicked page function
		 *
		 * @param {$.Event} event
		 */
		jumpToClickedPage: function (event) {
			event.preventDefault();
			const self = this;
			const clickedElement = $(event.currentTarget);

			if (clickedElement.hasClass('disabled')) {
				return;
			}

			const element = clickedElement.closest('div');
			const clickedPageNumber = parseInt(clickedElement.data('id'));

			self.paginationGoToPage(element, clickedPageNumber);
		},
		/**
		 * Jump to page from input
		 *
		 * @param {$.Event} event
		 */
		jumpToInputPage: function (event) {
			const self = this;
			const input = $(event.currentTarget);
			const container = input.closest('div.paginationDiv');
			if (13 !== event.which) {
				return;
			}

			event.stopImmediatePropagation();

			let currentPageElement = container.find('#pageNumber'),
				currentPageNumber = parseInt(currentPageElement.val()),
				newPageNumber = parseInt(input.val()),
				totalCount = parseInt(container.find('#totalCount').val());

			if (isNaN(newPageNumber)) {
				Vtiger_Helper_Js.showMessage({
					text: app.vtranslate('JS_PAGE_NOT_NUMBER'),
					type: 'info'
				});

				return;
			}

			if (newPageNumber > totalCount) {
				Vtiger_Helper_Js.showMessage({
					text: app.vtranslate('JS_PAGE_NOT_EXIST') + ' ' + newPageNumber,
					type: 'info'
				});

				return;
			}

			if (newPageNumber === currentPageNumber) {
				Vtiger_Helper_Js.showMessage({
					text: app.vtranslate('JS_YOU_ARE_IN_PAGE_NUMBER') + ' ' + newPageNumber,
					type: 'info'
				});

				return;
			}

			self.paginationGoToPage(input, newPageNumber);
		},
		/**
		 * Jump to next page
		 *
		 * @param {$.Event} event
		 */
		jumpToNextPage: function (event) {
			const self = this;
			const clickedElement = $(event.currentTarget);

			if (clickedElement.hasClass('disabled')) {
				return;
			}

			const element = clickedElement.closest('div');

			const pageNumber = parseInt(element.find('input#pageNumber').val());

			self.paginationGoToPage(element, pageNumber + 1);
		},
		/**
		 * Jump to previous page
		 *
		 * @param {$.Event} event
		 */
		jumpToPreviousPage: function (event) {
			event.preventDefault();
			const self = this;
			const clickedElement = $(event.currentTarget);

			if (clickedElement.hasClass('disabled')) {
				return;
			}

			const element = clickedElement.closest('div');
			const pageNumber = parseInt(element.find('input#pageNumber').val());
			if (pageNumber > 1) {
				self.paginationGoToPage(element, pageNumber - 1);
			}
		},
		/**
		 * Go to page
		 * @param {$} element
		 * @param {int} page
		 */
		paginationGoToPage: function (element, page) {
			const url = $('div.details div.contents').find('.showMailsModal').data('url');

			if (!url.length) {
				return;
			}

			let urlData = app.convertUrlToObject(url);

			urlData.page = page;
			urlData.type = 'All';

			let urlParams = {};
			urlParams.data = urlData;
			urlParams.url = 'index.php';

			element.closest('div.js-modal-container').trigger('hidden.bs.modal');

			$.get(urlParams).done(function (response) {
				app.showModalWindow(response, url);
			});
		}
	}
);
