<?php
/**
 * Fetching data to preview.
 *
 * @package   ReportTemplates
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Paweł Karczmarcyk <p.karczmarczyk@yetiforce.com>
 */

use App\Controller\Action;
use APP\Purifier;
use App\Report\Provider\FieldsProvider;
use App\Report\Provider\ReportProvider;
use App\Report\Report;
use App\Request;

/** Fetch preview report data */
class ReportTemplate_FetchPreviewDataAjax_Action extends Action
{
	/** {@inheritdoc} */
	public function checkPermission(App\Request $request): void
	{
		if (!$request->isEmpty('record', true) && !\App\Privilege::isPermitted($request->getModule(), 'DetailView', $request->getInteger('record'))) {
			throw new \App\Exceptions\NoPermittedToRecord('ERR_NO_PERMISSIONS_FOR_THE_RECORD', 406);
		}
	}

	/** {@inheritdoc} */
	public function process(Request $request): void
	{
		$reportId = $request->getByType('reportId', Purifier::INTEGER);
		$userId = \App\User::getCurrentUserId();

		$dataProvider = Report::get(ReportProvider::class);
		$fieldsProvider = Report::get(FieldsProvider::class);

		$previewData = $dataProvider->provide($reportId, $userId, true);
		$previewHeaders = $fieldsProvider->provide($reportId, \count($previewData) > 0 ? $previewData[0] : []);

		$response = new Vtiger_Response();
		$response->setResult(['previewData' => $previewData, 'previewHeadersData' => $previewHeaders]);
		$response->emit();
	}
}
