<?php

/**
 * Comarch payments synchronization file.
 *
 * The file is part of the paid functionality. Using the file is allowed only after purchasing a subscription.
 * File modification allowed only with the consent of the system producer.
 *
 * @package Integration
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\Integrations\Comarch\Xl\Synchronizer;

/**
 * Comarch payments synchronization class.
 */
class Payments extends \App\Integrations\Comarch\Synchronizer
{
	/** {@inheritdoc} */
	const LIMIT_NAME = 'payments_limit';

	/** {@inheritdoc} */
	public function process(): void
	{
		$mapModel = $this->getMapModel();
		if (\App\Module::isModuleActive($mapModel->getModule())) {
			$direction = (int) $this->config->get('direction_payments');
			if (self::DIRECTION_TWO_WAY === $direction || self::DIRECTION_API_TO_YF === $direction) {
				$this->runQueue('import');
				$this->import();
			}
		}
	}

	/**
	 * Import payments from Comarch.
	 *
	 * @return void
	 */
	public function import(): void
	{
		$this->processStart('import');
		$i = 0;
		try {
			// if ($rows = $this->getFromApi('settlement?dokumentId=1128')) {
			if ($rows = $this->getFromApi('settlement?' . $this->getFromApiCond())) {
				foreach ($rows as $id => $row) {
					foreach ($row['platnosci'] as $payment) {
						$payment['id'] = $row['id'];
						$this->importItem($payment);
					}
					$this->config->setScan('import' . $this->name, 'id', $id);
					++$i;
				}
			}
			$this->config->setEndScan('import' . $this->name, $this->lastScan['start_date']);
		} catch (\Throwable $ex) {
			if (404 != $ex->getCode()) {
				$this->logError('import ' . $this->name, null, $ex);
			}
		}
		$this->processEnd('import', ['imported' => $i]);
	}

	/** {@inheritdoc} */
	public function importById(int $apiId): int
	{
		$id = 0;
		try {
			$rows = $this->getFromApi('settlement?dokumentId=' . $apiId);
			if ($rows) {
				foreach ($rows as $id => $row) {
					foreach ($row['platnosci'] as $payment) {
						$payment['id'] = $row['id'];
						$this->importItem($payment);
					}
				}
				$mapModel = $this->getMapModel();
				$id = $this->imported[$row[$mapModel::API_NAME_ID]] ?? 0;
			} else {
				$this->controller->log("Import {$this->name} by id [Empty details]", ['apiId' => $apiId]);
				\App\Log::error("Error during import {$this->name}: Empty details", self::LOG_CATEGORY);
			}
		} catch (\Throwable $ex) {
			if (404 != $ex->getCode()) {
				$this->logError("import {$this->name} by id", ['apiId' => $apiId, 'API' => $row ?? []], $ex);
			}
		}
		return $id;
	}
}
