<?php

namespace App\Conditions\QueryFields;

/**
 * Id Query Field Class.
 *
 * @package UIType
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */
class IdField extends StringField
{
	/** {@inheritdoc} */
	public function operatorS()
	{
		return ['like', $this->getColumnName(), $this->getValue() . '%', false];
	}

	/** {@inheritdoc} */
	public function getColumnName(): string
	{
		if ($this->fullColumnName) {
			return $this->fullColumnName;
		}
		return $this->fullColumnName = $this->queryGenerator->getColumnName('id');
	}

	/** {@inheritdoc} */
	public function operatorEw()
	{
		return ['like', $this->getColumnName(), '%' . $this->getValue(), false];
	}

	/** {@inheritdoc} */
	public function operatorA(): array
	{
		return ['>', $this->getColumnName(), $this->getValue()];
	}

	/**
	 * Equal IDs.
	 *
	 * @return array
	 */
	public function operatorEid(): array
	{
		$condition = ['or'];
		foreach (explode('##', $this->value) as $value) {
			$condition[] = [$this->getColumnName() => $value];
		}

		return $condition;
	}
}
