<?php
/**
 * Roundcube cli file.
 *
 * @package Cli
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\Cli;

use App\Db;
use yii\db\Exception;

/**
 * Roundcube cli class.
 */
class Roundcube extends Base
{
	/** {@inheritdoc} */
	public string $moduleName = 'Roundcube';

	/** {@inheritdoc} */
	protected array $methods = [
		'clearUsersPreferences' => 'Clear users preferences',
		'clearUsersCache' => 'Clear users cache',
		'clearUsersSession' => 'Clear users session',
	];

	/**
	 * Clear users preferences.
	 *
	 * @return void
	 * @throws Exception
	 */
	public function clearUsersPreferences(): void
	{
		Db::getInstance()->createCommand()->update('roundcube_users', ['preferences' => ''])->execute();
		if (!$this->climate->arguments->defined('action')) {
			$this->returnToActionList();
		}
	}

	/**
	 * Clear users cache.
	 *
	 * @return void
	 * @throws Exception
	 */
	public function clearUsersCache(): void
	{
		$createCommand = Db::getInstance()->createCommand();
		foreach (['roundcube_cache', 'roundcube_cache_index', 'roundcube_cache_messages', 'roundcube_cache_shared', 'roundcube_cache_thread'] as $table) {
			$createCommand->truncateTable($table)->execute();
		}
		if (!$this->climate->arguments->defined('action')) {
			$this->returnToActionList();
		}
	}

	/**
	 * Clear user's session.
	 *
	 * @return void
	 * @throws Exception
	 */
	public function clearUsersSession(): void
	{
		Db::getInstance()->createCommand()->truncateTable('roundcube_session')->execute();
		if (!$this->climate->arguments->defined('action')) {
			$this->returnToActionList();
		}
	}
}
